/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.autodetector;

import java.lang.annotation.Annotation;
import java.util.List;
import org.seasar.chronos.core.task.TaskValidator;
import org.seasar.framework.autodetector.impl.AbstractClassAutoDetector;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourcesUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class TaskClassAutoDetector
extends AbstractClassAutoDetector {
    private static final String PACKAGE_NAME_TASK = "task";
    protected final List<Class<? extends Annotation>> annotations = CollectionsUtil.newArrayList();
    protected NamingConvention namingConvention;
    protected ClassLoader classLoader;
    private TaskValidator taskValidator;

    @Binding(bindingType=BindingType.MAY)
    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @InitMethod
    public void init() {
        if (this.namingConvention != null) {
            String taskPackageName = PACKAGE_NAME_TASK;
            for (String rootPackageName : this.namingConvention.getRootPackageNames()) {
                String packageName = ClassUtil.concatName((String)rootPackageName, (String)PACKAGE_NAME_TASK);
                this.addTargetPackageName(packageName);
            }
        }
    }

    public void addAnnotation(Class<? extends Annotation> annotation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detect(final ClassTraversal.ClassHandler handler) {
        for (int i = 0; i < this.getTargetPackageNameSize(); ++i) {
            String packageName = this.getTargetPackageName(i);
            for (ResourcesUtil.Resources resources : ResourcesUtil.getResourcesTypes((String)packageName)) {
                try {
                    resources.forEach(new ClassTraversal.ClassHandler(){

                        public void processClass(String packageName, String shortClassName) {
                            if (packageName.startsWith(packageName) && TaskClassAutoDetector.this.isTask(packageName, shortClassName)) {
                                handler.processClass(packageName, shortClassName);
                            }
                        }
                    });
                }
                finally {
                    resources.close();
                }
            }
        }
    }

    protected boolean isTask(String packageName, String shortClassName) {
        String name = ClassUtil.concatName((String)packageName, (String)shortClassName);
        Class<?> clazz = this.getClass(name);
        return this.taskValidator.isValid(clazz);
    }

    protected Class<?> getClass(String className) {
        if (this.classLoader != null) {
            return ReflectionUtil.forName((String)className, (ClassLoader)this.classLoader);
        }
        return ReflectionUtil.forNameNoException((String)className);
    }

    public void setTaskValidator(TaskValidator taskValidator) {
        this.taskValidator = taskValidator;
    }
}

