/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.event;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.seasar.chronos.core.Scheduler;
import org.seasar.chronos.core.SchedulerEventListener;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.executor.ExecutorServiceFactory;
import org.seasar.chronos.core.impl.TaskStateType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerEventHandler {
    private final Logger log = Logger.getLogger(SchedulerEventHandler.class);
    private ExecutorServiceFactory executorServiceFacotry;
    private ExecutorService executorService;
    private final CopyOnWriteArrayList<SchedulerEventListener> schedulerEventListener = CollectionsUtil.newCopyOnWriteArrayList();
    private boolean async;
    private Scheduler scheduler;

    public boolean add(SchedulerEventListener listener) {
        return this.schedulerEventListener.add(listener);
    }

    public void fireAddTaskScheduleEntry(final TaskStateType taskStateType, final TaskScheduleEntry taskScheduleEntry) {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.addTaskScheduleEntry(SchedulerEventHandler.this.scheduler, taskStateType, taskScheduleEntry);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireCancelTask(final Object task) {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.cancelTask(SchedulerEventHandler.this.scheduler, task);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireEndScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.endScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireExceptionTask(final Object task, final Exception e) {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.exceptionTask(SchedulerEventHandler.this.scheduler, task, e);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireEndTask(final Object task) {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.endTask(SchedulerEventHandler.this.scheduler, task);
                }
            });
            this.waitFuture(future);
        }
    }

    public void firePauseScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.pauseScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireResumeScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.resumeScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireRegisterTaskAfterScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.resigtTaskAfterScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireRegisterTaskBeforeScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.resigtTaskBeforeScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireRemoveTaskScheduleEntry(final TaskStateType taskStateType, final TaskScheduleEntry taskScheduleEntry) {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.removeTaskScheduleEntry(SchedulerEventHandler.this.scheduler, taskStateType, taskScheduleEntry);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireShutdownScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.shutdownScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireStartScheduler() {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.startScheduler(SchedulerEventHandler.this.scheduler);
                }
            });
            this.waitFuture(future);
        }
    }

    public void fireStartTask(final Object task) {
        for (final SchedulerEventListener listener : this.schedulerEventListener) {
            Future<?> future = this.executorService.submit(new Runnable(){

                public void run() {
                    listener.startTask(SchedulerEventHandler.this.scheduler, task);
                }
            });
            this.waitFuture(future);
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean remove(SchedulerEventListener listener) {
        return this.schedulerEventListener.remove(listener);
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    private void waitFuture(Future<?> future) {
        if (!this.async) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                this.log.error((Object)"\u87b3\u6eaf\uff61\u5fa1\uff7e\u53e5\uff64\u60b6\u2032\u900b\uff7a\u9015\u6e98\uff20\u7e3a\uff7e\u7e3a\u52b1\u25c6", (Throwable)e);
            }
        }
    }

    public void setExecutorServiceFacotry(ExecutorServiceFactory executorServiceFacotry) {
        this.executorServiceFacotry = executorServiceFacotry;
        this.executorService = this.executorServiceFacotry.create(ThreadPoolType.CACHED, null);
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

