/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.handler.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.handler.impl.AbstractScheduleExecuteHandler;
import org.seasar.chronos.core.impl.TaskStateType;
import org.seasar.chronos.core.schedule.TaskScheduleEntryManager;
import org.seasar.chronos.core.task.TaskExecutorService;

public class ScheduleExecuteStartHandler
extends AbstractScheduleExecuteHandler {
    private void fireExceptionTaskEvent(TaskExecutorService tes, Exception e) {
        if (this.schedulerEventHandler != null) {
            this.schedulerEventHandler.fireExceptionTask(tes.getTask(), e);
        }
    }

    private void fireEndTaskEvent(TaskExecutorService tes) {
        if (this.schedulerEventHandler != null) {
            this.schedulerEventHandler.fireEndTask(tes.getTask());
        }
    }

    private void fireStartTaskEvent(TaskExecutorService tes) {
        if (this.schedulerEventHandler != null) {
            this.schedulerEventHandler.fireStartTask(tes.getTask());
        }
    }

    public void handleRequest() throws InterruptedException {
        this.taskScheduleEntryManager.forEach(TaskStateType.SCHEDULED, new TaskScheduleEntryManager.TaskScheduleEntryHanlder(){

            public Object processTaskScheduleEntry(TaskScheduleEntry taskScheduleEntry) {
                TaskExecutorService tes = taskScheduleEntry.getTaskExecutorService();
                tes.hotdeployStart();
                if (!tes.isPrepared()) {
                    tes.prepare();
                    try {
                        tes.initialize();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    tes.hotdeployStop();
                    return null;
                }
                if (!tes.isExecuted() && tes.getTaskPropertyReader().isStartTask(false)) {
                    Object task = tes.getTask();
                    Class<?> taskClass = tes.getTaskClass();
                    taskScheduleEntry.setTask(task);
                    taskScheduleEntry.setTaskClass(taskClass);
                    log.log("DCHRONOS0121", new Object[]{tes.getTaskPropertyReader().getTaskName(null)});
                    TaskExecutorServiceCallable tesc = new TaskExecutorServiceCallable();
                    tesc.setTaskExecutorService(tes);
                    tesc.setTaskScheduleEntry(taskScheduleEntry);
                    Future<TaskExecutorService> taskStaterFuture = ScheduleExecuteStartHandler.this.executorService.submit(tesc);
                    taskScheduleEntry.setTaskStaterFuture(taskStaterFuture);
                } else {
                    tes.hotdeployStop();
                }
                return null;
            }
        });
    }

    private void taskExecute(TaskExecutorService tes, String nextTaskName) throws InterruptedException {
        try {
            tes.execute(nextTaskName);
            tes.waitOne();
        }
        catch (RejectedExecutionException ex) {
            String taskName = tes.getTaskPropertyReader().getTaskName(null);
            log.log("ECHRONOS0002", new Object[]{taskName}, (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskExecutorServiceCallable
    implements Callable<TaskExecutorService> {
        private TaskExecutorService taskExecutorService;
        private TaskScheduleEntry taskScheduleEntry;

        private TaskExecutorServiceCallable() {
        }

        public void setTaskExecutorService(TaskExecutorService taskExecutorService) {
            this.taskExecutorService = taskExecutorService;
        }

        public void setTaskScheduleEntry(TaskScheduleEntry taskScheduleEntry) {
            this.taskScheduleEntry = taskScheduleEntry;
        }

        @Override
        public TaskExecutorService call() throws Exception {
            String taskName;
            block7: {
                taskName = this.taskExecutorService.getTaskPropertyReader().getTaskName(null);
                log.log("DCHRONOS0122", new Object[]{taskName});
                ScheduleExecuteStartHandler.this.taskScheduleEntryManager.addTaskScheduleEntry(TaskStateType.RUNNING, this.taskScheduleEntry);
                if (!this.taskExecutorService.getTaskPropertyReader().isReScheduleTask(false)) {
                    ScheduleExecuteStartHandler.this.taskScheduleEntryManager.removeTaskScheduleEntry(TaskStateType.SCHEDULED, this.taskScheduleEntry);
                }
                try {
                    try {
                        ScheduleExecuteStartHandler.this.fireStartTaskEvent(this.taskExecutorService);
                        String nextTaskName = this.taskExecutorService.start();
                        ScheduleExecuteStartHandler.this.taskExecute(this.taskExecutorService, nextTaskName);
                    }
                    catch (Exception e) {
                        this.taskExecutorService.setException(e);
                        this.taskExecutorService.catchException(e);
                        ScheduleExecuteStartHandler.this.fireExceptionTaskEvent(this.taskExecutorService, e);
                        String nextTaskName = this.taskExecutorService.end();
                        log.log("DCHRONOS0123", new Object[]{taskName});
                        ScheduleExecuteStartHandler.this.fireEndTaskEvent(this.taskExecutorService);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    String nextTaskName = this.taskExecutorService.end();
                    log.log("DCHRONOS0123", new Object[]{taskName});
                    ScheduleExecuteStartHandler.this.fireEndTaskEvent(this.taskExecutorService);
                    throw throwable;
                }
                String nextTaskName = this.taskExecutorService.end();
                log.log("DCHRONOS0123", new Object[]{taskName});
                ScheduleExecuteStartHandler.this.fireEndTaskEvent(this.taskExecutorService);
            }
            ScheduleExecuteStartHandler.this.taskScheduleEntryManager.removeTaskScheduleEntry(TaskStateType.RUNNING, this.taskScheduleEntry);
            if (!this.taskExecutorService.getTaskPropertyReader().isReScheduleTask(false)) {
                ScheduleExecuteStartHandler.this.taskScheduleEntryManager.addTaskScheduleEntry(TaskStateType.UNSCHEDULED, this.taskScheduleEntry);
            }
            this.taskExecutorService.unprepare();
            log.log("DCHRONOS0124", new Object[]{taskName});
            this.taskExecutorService.hotdeployStop();
            return this.taskExecutorService;
        }
    }
}

