/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.impl;

import java.lang.annotation.Annotation;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.task.TaskAnnotationReader;
import org.seasar.chronos.core.task.TaskTriggerFinder;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskTriggerFinderImpl
implements TaskTriggerFinder {
    private static final String NAME_SPACE_ORG_SEASAR_CHRONOS_CORE = "org.seasar.chronos.core";
    private static final String NAME_SPACE_TRIGGER_C = ".trigger.C";
    private NamingConvention namingConvention;

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    private Class<?> getTriggerAnnotationClass(String packageName, String className) {
        StringBuilder sb = new StringBuilder(packageName);
        sb.append(NAME_SPACE_TRIGGER_C);
        sb.append(className);
        Class triggerClass = ReflectionUtil.forNameNoException((String)sb.toString());
        return triggerClass;
    }

    public Class<?> findTriggerAnnotationClassForRootPackages(String annotationName) {
        Class<?> result = null;
        for (String packageName : this.namingConvention.getRootPackageNames()) {
            result = this.getTriggerAnnotationClass(packageName, annotationName);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public TaskTrigger find(Annotation[] annotations, TaskAnnotationReader.TriggerAnnotationHandler triggerAnnotationHandler) {
        for (Annotation annotation : annotations) {
            TaskTrigger taskTrigger;
            Class<? extends Annotation> annotaionClass = annotation.annotationType();
            String annotationName = annotaionClass.getSimpleName();
            if (!annotationName.endsWith("Trigger")) continue;
            Class<?> triggerAnnotationClass = this.getTriggerAnnotationClass(NAME_SPACE_ORG_SEASAR_CHRONOS_CORE, annotationName);
            if (triggerAnnotationClass == null) {
                triggerAnnotationClass = this.findTriggerAnnotationClassForRootPackages(annotationName);
            }
            if ((taskTrigger = triggerAnnotationHandler.process(annotation, triggerAnnotationClass)) == null) continue;
            return taskTrigger;
        }
        return null;
    }
}

