/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.util.DateConverter;

public class COSDictionary
extends COSBase {
    private static final String PATH_SEPARATOR = "/";
    private Map items = new HashMap();
    private List keys = new ArrayList();

    public COSDictionary() {
    }

    public COSDictionary(COSDictionary dict) {
        this.items = new HashMap(dict.items);
        this.keys = new ArrayList(dict.keys);
    }

    public boolean containsValue(Object value) {
        boolean contains = this.items.containsValue(value);
        if (!contains && value instanceof COSObject) {
            contains = this.items.containsValue(((COSObject)value).getObject());
        }
        return contains;
    }

    public COSName getKeyForValue(Object value) {
        COSName key = null;
        Iterator iter = this.items.entrySet().iterator();
        while (key == null && iter.hasNext()) {
            Map.Entry next = iter.next();
            Object nextValue = next.getValue();
            if (!nextValue.equals(value) && (!(nextValue instanceof COSObject) || !((COSObject)nextValue).getObject().equals(value))) continue;
            key = (COSName)next.getKey();
        }
        return key;
    }

    public int size() {
        return this.keys.size();
    }

    public void clear() {
        this.items.clear();
        this.keys.clear();
    }

    public COSBase getDictionaryObject(String key) {
        return this.getDictionaryObject(COSName.getPDFName(key));
    }

    public COSBase getDictionaryObject(String firstKey, String secondKey) {
        COSBase retval = this.getDictionaryObject(COSName.getPDFName(firstKey));
        if (retval == null) {
            retval = this.getDictionaryObject(COSName.getPDFName(secondKey));
        }
        return retval;
    }

    public COSBase getDictionaryObject(String[] keyList) {
        COSBase retval = null;
        for (int i = 0; i < keyList.length && retval == null; ++i) {
            retval = this.getDictionaryObject(COSName.getPDFName(keyList[i]));
        }
        return retval;
    }

    public COSBase getDictionaryObject(COSName key) {
        COSBase retval = (COSBase)this.items.get(key);
        if (retval instanceof COSObject) {
            retval = ((COSObject)retval).getObject();
        }
        if (retval instanceof COSNull) {
            retval = null;
        }
        return retval;
    }

    public void setItem(COSName key, COSBase value) {
        if (value == null) {
            this.removeItem(key);
        } else {
            if (!this.items.containsKey(key)) {
                this.keys.add(key);
            }
            this.items.put(key, value);
        }
    }

    public void setItem(COSName key, COSObjectable value) {
        COSBase base = null;
        if (value != null) {
            base = value.getCOSObject();
        }
        this.setItem(key, base);
    }

    public void setItem(String key, COSObjectable value) {
        this.setItem(COSName.getPDFName(key), value);
    }

    public void setBoolean(String key, boolean value) {
        this.setItem(COSName.getPDFName(key), (COSBase)COSBoolean.getBoolean(value));
    }

    public void setBoolean(COSName key, boolean value) {
        this.setItem(key, (COSBase)COSBoolean.getBoolean(value));
    }

    public void setItem(String key, COSBase value) {
        this.setItem(COSName.getPDFName(key), value);
    }

    public void setName(String key, String value) {
        this.setName(COSName.getPDFName(key), value);
    }

    public void setName(COSName key, String value) {
        COSName name = null;
        if (value != null) {
            name = COSName.getPDFName(value);
        }
        this.setItem(key, (COSBase)name);
    }

    public void setDate(String key, Calendar date) {
        this.setDate(COSName.getPDFName(key), date);
    }

    public void setDate(COSName key, Calendar date) {
        this.setString(key, DateConverter.toString(date));
    }

    public void setEmbeddedDate(String embedded, String key, Calendar date) {
        this.setEmbeddedDate(embedded, COSName.getPDFName(key), date);
    }

    public void setEmbeddedDate(String embedded, COSName key, Calendar date) {
        COSDictionary dic = (COSDictionary)this.getDictionaryObject(embedded);
        if (dic == null && date != null) {
            dic = new COSDictionary();
            this.setItem(embedded, (COSBase)dic);
        }
        if (dic != null) {
            dic.setDate(key, date);
        }
    }

    public void setString(String key, String value) {
        this.setString(COSName.getPDFName(key), value);
    }

    public void setString(COSName key, String value) {
        COSString name = null;
        if (value != null) {
            name = new COSString(value);
        }
        this.setItem(key, name);
    }

    public void setEmbeddedString(String embedded, String key, String value) {
        this.setEmbeddedString(embedded, COSName.getPDFName(key), value);
    }

    public void setEmbeddedString(String embedded, COSName key, String value) {
        COSDictionary dic = (COSDictionary)this.getDictionaryObject(embedded);
        if (dic == null && value != null) {
            dic = new COSDictionary();
            this.setItem(embedded, (COSBase)dic);
        }
        if (dic != null) {
            dic.setString(key, value);
        }
    }

    public void setInt(String key, int value) {
        this.setInt(COSName.getPDFName(key), value);
    }

    public void setInt(COSName key, int value) {
        COSInteger intVal = null;
        intVal = new COSInteger(value);
        this.setItem(key, (COSBase)intVal);
    }

    public void setLong(String key, long value) {
        this.setLong(COSName.getPDFName(key), value);
    }

    public void setLong(COSName key, long value) {
        COSInteger intVal = null;
        intVal = new COSInteger(value);
        this.setItem(key, (COSBase)intVal);
    }

    public void setEmbeddedInt(String embeddedDictionary, String key, int value) {
        this.setEmbeddedInt(embeddedDictionary, COSName.getPDFName(key), value);
    }

    public void setEmbeddedInt(String embeddedDictionary, COSName key, int value) {
        COSDictionary embedded = (COSDictionary)this.getDictionaryObject(embeddedDictionary);
        if (embedded == null) {
            embedded = new COSDictionary();
            this.setItem(embeddedDictionary, (COSBase)embedded);
        }
        embedded.setInt(key, value);
    }

    public void setFloat(String key, float value) {
        this.setFloat(COSName.getPDFName(key), value);
    }

    public void setFloat(COSName key, float value) {
        COSFloat fltVal = new COSFloat(value);
        this.setItem(key, (COSBase)fltVal);
    }

    public String getNameAsString(String key) {
        return this.getNameAsString(COSName.getPDFName(key));
    }

    public String getNameAsString(COSName key) {
        String retval = null;
        COSBase name = this.getDictionaryObject(key);
        if (name != null) {
            if (name instanceof COSName) {
                retval = ((COSName)name).getName();
            } else if (name instanceof COSString) {
                retval = ((COSString)name).getString();
            }
        }
        return retval;
    }

    public String getNameAsString(String key, String defaultValue) {
        return this.getNameAsString(COSName.getPDFName(key), defaultValue);
    }

    public String getNameAsString(COSName key, String defaultValue) {
        String retval = this.getNameAsString(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public String getString(String key) {
        return this.getString(COSName.getPDFName(key));
    }

    public String getString(COSName key) {
        String retval = null;
        COSBase value = this.getDictionaryObject(key);
        if (value != null && value instanceof COSString) {
            retval = ((COSString)value).getString();
        }
        return retval;
    }

    public String getString(String key, String defaultValue) {
        return this.getString(COSName.getPDFName(key), defaultValue);
    }

    public String getString(COSName key, String defaultValue) {
        String retval = this.getString(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public String getEmbeddedString(String embedded, String key) {
        return this.getEmbeddedString(embedded, COSName.getPDFName(key), null);
    }

    public String getEmbeddedString(String embedded, COSName key) {
        return this.getEmbeddedString(embedded, key, null);
    }

    public String getEmbeddedString(String embedded, String key, String defaultValue) {
        return this.getEmbeddedString(embedded, COSName.getPDFName(key), defaultValue);
    }

    public String getEmbeddedString(String embedded, COSName key, String defaultValue) {
        String retval = defaultValue;
        COSDictionary dic = (COSDictionary)this.getDictionaryObject(embedded);
        if (dic != null) {
            retval = dic.getString(key, defaultValue);
        }
        return retval;
    }

    public Calendar getDate(String key) throws IOException {
        return this.getDate(COSName.getPDFName(key));
    }

    public Calendar getDate(COSName key) throws IOException {
        COSString date = (COSString)this.getDictionaryObject(key);
        return DateConverter.toCalendar(date);
    }

    public Calendar getDate(String key, Calendar defaultValue) throws IOException {
        return this.getDate(COSName.getPDFName(key), defaultValue);
    }

    public Calendar getDate(COSName key, Calendar defaultValue) throws IOException {
        Calendar retval = this.getDate(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public Calendar getEmbeddedDate(String embedded, String key) throws IOException {
        return this.getEmbeddedDate(embedded, COSName.getPDFName(key), null);
    }

    public Calendar getEmbeddedDate(String embedded, COSName key) throws IOException {
        return this.getEmbeddedDate(embedded, key, null);
    }

    public Calendar getEmbeddedDate(String embedded, String key, Calendar defaultValue) throws IOException {
        return this.getEmbeddedDate(embedded, COSName.getPDFName(key), defaultValue);
    }

    public Calendar getEmbeddedDate(String embedded, COSName key, Calendar defaultValue) throws IOException {
        Calendar retval = defaultValue;
        COSDictionary eDic = (COSDictionary)this.getDictionaryObject(embedded);
        if (eDic != null) {
            retval = eDic.getDate(key, defaultValue);
        }
        return retval;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(COSName.getPDFName(key), defaultValue);
    }

    public boolean getBoolean(COSName key, boolean defaultValue) {
        boolean retval = defaultValue;
        COSBase bool = this.getDictionaryObject(key);
        if (bool != null && bool instanceof COSBoolean) {
            retval = ((COSBoolean)bool).getValue();
        }
        return retval;
    }

    public int getEmbeddedInt(String embeddedDictionary, String key) {
        return this.getEmbeddedInt(embeddedDictionary, COSName.getPDFName(key));
    }

    public int getEmbeddedInt(String embeddedDictionary, COSName key) {
        return this.getEmbeddedInt(embeddedDictionary, key, -1);
    }

    public int getEmbeddedInt(String embeddedDictionary, String key, int defaultValue) {
        return this.getEmbeddedInt(embeddedDictionary, COSName.getPDFName(key), defaultValue);
    }

    public int getEmbeddedInt(String embeddedDictionary, COSName key, int defaultValue) {
        int retval = defaultValue;
        COSDictionary embedded = (COSDictionary)this.getDictionaryObject(embeddedDictionary);
        if (embedded != null) {
            retval = embedded.getInt(key, defaultValue);
        }
        return retval;
    }

    public int getInt(String key) {
        return this.getInt(COSName.getPDFName(key));
    }

    public int getInt(COSName key) {
        return this.getInt(key, -1);
    }

    public int getInt(String[] keyList, int defaultValue) {
        int retval = defaultValue;
        COSBase obj = this.getDictionaryObject(keyList);
        if (obj != null && obj instanceof COSNumber) {
            retval = ((COSNumber)obj).intValue();
        }
        return retval;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(new String[]{key}, defaultValue);
    }

    public int getInt(COSName key, int defaultValue) {
        return this.getInt(key.getName(), defaultValue);
    }

    public long getLong(String key) {
        return this.getLong(COSName.getPDFName(key));
    }

    public long getLong(COSName key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String[] keyList, long defaultValue) {
        long retval = defaultValue;
        COSBase obj = this.getDictionaryObject(keyList);
        if (obj != null && obj instanceof COSNumber) {
            retval = ((COSNumber)obj).longValue();
        }
        return retval;
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(new String[]{key}, defaultValue);
    }

    public long getLong(COSName key, long defaultValue) {
        return this.getLong(key.getName(), defaultValue);
    }

    public float getFloat(String key) {
        return this.getFloat(COSName.getPDFName(key));
    }

    public float getFloat(COSName key) {
        return this.getFloat(key, -1.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(COSName.getPDFName(key), defaultValue);
    }

    public float getFloat(COSName key, float defaultValue) {
        float retval = defaultValue;
        COSBase obj = this.getDictionaryObject(key);
        if (obj != null && obj instanceof COSNumber) {
            retval = ((COSNumber)obj).floatValue();
        }
        return retval;
    }

    public void removeItem(COSName key) {
        this.keys.remove(key);
        this.items.remove(key);
    }

    public COSBase getItem(COSName key) {
        return (COSBase)this.items.get(key);
    }

    public List keyList() {
        return this.keys;
    }

    public Collection getValues() {
        return this.items.values();
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDictionary(this);
    }

    public void addAll(COSDictionary dic) {
        Iterator dicKeys = dic.keyList().iterator();
        while (dicKeys.hasNext()) {
            COSName key = (COSName)dicKeys.next();
            COSBase value = dic.getItem(key);
            if (key.getName().equals("Size") && this.keys.contains(COSName.getPDFName("Size"))) continue;
            this.setItem(key, value);
        }
    }

    public void mergeInto(COSDictionary dic) {
        Iterator dicKeys = dic.keyList().iterator();
        while (dicKeys.hasNext()) {
            COSName key = (COSName)dicKeys.next();
            COSBase value = dic.getItem(key);
            if (this.getItem(key) != null) continue;
            this.setItem(key, value);
        }
    }

    public COSBase getObjectFromPath(String objPath) {
        COSBase retval = null;
        String[] path = objPath.split(PATH_SEPARATOR);
        retval = this;
        for (int i = 0; i < path.length; ++i) {
            if (retval instanceof COSArray) {
                int idx = new Integer(path[i].replaceAll("\\[", "").replaceAll("\\]", ""));
                retval = ((COSArray)retval).getObject(idx);
                continue;
            }
            if (!(retval instanceof COSDictionary)) continue;
            retval = retval.getDictionaryObject(path[i]);
        }
        return retval;
    }

    public String toString() {
        String retVal = "COSDictionary{";
        for (int i = 0; i < this.size(); ++i) {
            COSName key = (COSName)this.keyList().get(i);
            retVal = retVal + "(" + key + ":" + this.getDictionaryObject(key).toString() + ") ";
        }
        retVal = retVal + "}";
        return retVal;
    }
}

