/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class PDObjectStream
extends PDStream {
    public PDObjectStream(COSStream str) {
        super(str);
    }

    public static PDObjectStream createStream(PDDocument document) {
        COSStream cosStream = new COSStream(document.getDocument().getScratchFile());
        PDObjectStream strm = new PDObjectStream(cosStream);
        strm.getStream().setName("Type", "ObjStm");
        return strm;
    }

    public String getType() {
        return this.getStream().getNameAsString("Type");
    }

    public int getNumberOfObjects() {
        return this.getStream().getInt("N", 0);
    }

    public void setNumberOfObjects(int n) {
        this.getStream().setInt("N", n);
    }

    public int getFirstByteOffset() {
        return this.getStream().getInt("First", 0);
    }

    public void setFirstByteOffset(int n) {
        this.getStream().setInt("First", n);
    }

    public PDObjectStream getExtends() {
        PDObjectStream retval = null;
        COSStream stream = (COSStream)this.getStream().getDictionaryObject("Extends");
        if (stream != null) {
            retval = new PDObjectStream(stream);
        }
        return retval;
    }

    public void setExtends(PDObjectStream stream) {
        this.getStream().setItem("Extends", (COSObjectable)stream);
    }
}

