/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.io.IOException;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationPopup;

public abstract class PDAnnotationMarkup
extends PDAnnotation {
    public static final String RT_REPLY = "R";
    public static final String RT_GROUP = "Group";

    public PDAnnotationMarkup() {
    }

    public PDAnnotationMarkup(COSDictionary dict) {
        super(dict);
    }

    public String getTitlePopup() {
        return this.getDictionary().getString("T");
    }

    public void setTitlePopup(String t) {
        this.getDictionary().setString("T", t);
    }

    public PDAnnotationPopup getPopup() {
        COSDictionary popup = (COSDictionary)this.getDictionary().getDictionaryObject("Popup");
        if (popup != null) {
            return new PDAnnotationPopup(popup);
        }
        return null;
    }

    public void setPopup(PDAnnotationPopup popup) {
        this.getDictionary().setItem("Popup", (COSObjectable)popup);
    }

    public float getConstantOpacity() {
        return this.getDictionary().getFloat("CA", 1.0f);
    }

    public void setConstantOpacity(float ca) {
        this.getDictionary().setFloat("CA", ca);
    }

    public PDTextStream getRichContents() {
        COSBase rc = this.getDictionary().getDictionaryObject("RC");
        if (rc != null) {
            return PDTextStream.createTextStream(rc);
        }
        return null;
    }

    public void setRichContents(PDTextStream rc) {
        this.getDictionary().setItem("RC", (COSObjectable)rc);
    }

    public Calendar getCreationDate() throws IOException {
        return this.getDictionary().getDate("CreationDate");
    }

    public void setCreationDate(Calendar creationDate) {
        this.getDictionary().setDate("CreationDate", creationDate);
    }

    public PDAnnotation getInReplyTo() throws IOException {
        COSBase irt = this.getDictionary().getDictionaryObject("IRT");
        return PDAnnotation.createAnnotation(irt);
    }

    public void setInReplyTo(PDAnnotation irt) {
        this.getDictionary().setItem("IRT", (COSObjectable)irt);
    }

    public String getSubject() {
        return this.getDictionary().getString("Subj");
    }

    public void setSubject(String subj) {
        this.getDictionary().setString("Subj", subj);
    }

    public String getReplyType() {
        return this.getDictionary().getNameAsString("RT", RT_REPLY);
    }

    public void setReplyType(String rt) {
        this.getDictionary().setName("RT", rt);
    }

    public String getIntent() {
        return this.getDictionary().getNameAsString("IT");
    }

    public void setIntent(String it) {
        this.getDictionary().setName("IT", it);
    }
}

