/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.Normalizer;

public class ICU4JImpl {
    Bidi bidi = new Bidi();

    public ICU4JImpl() {
        this.bidi.setReorderingMode(5);
    }

    public String makeLineLogicalOrder(String str, boolean isRtlDominant) {
        this.bidi.setPara(str, isRtlDominant ? (byte)1 : 0, null);
        return this.bidi.writeReordered(2);
    }

    public String normalizePres(String str) {
        String retStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\ufb00' && c <= '\ufdff' || c >= '\ufe70' && c <= '\ufeff') {
                if (c == '\ufdf2' && i > 0 && (str.charAt(i - 1) == '\u0627' || str.charAt(i - 1) == '\ufe8d')) {
                    retStr = retStr + "\u0644\u0644\u0647";
                    continue;
                }
                retStr = retStr + Normalizer.normalize((int)c, (Normalizer.Mode)Normalizer.NFKC).trim();
                continue;
            }
            retStr = retStr + str.charAt(i);
        }
        return retStr;
    }

    public String normalizeDiac(String str) {
        String retStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            retStr = Character.getType(c) == 6 || Character.getType(c) == 27 || Character.getType(c) == 4 ? retStr + Normalizer.normalize((int)c, (Normalizer.Mode)Normalizer.NFKC).trim() : retStr + str.charAt(i);
        }
        return retStr;
    }
}

