/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.where;

import java.util.List;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.where.ComposableWhere;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposableWhereContext
implements Where {
    protected StringBuilder criteriaSb = new StringBuilder(256);
    protected List<Object> paramList = CollectionsUtil.newArrayList();
    protected List<String> propertyNameList = CollectionsUtil.newArrayList();

    @Override
    public String getCriteria() {
        return new String(this.criteriaSb);
    }

    @Override
    public Object[] getParams() {
        return this.paramList.toArray();
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNameList.toArray(new String[this.propertyNameList.size()]);
    }

    public int getCriteriaLength() {
        return this.criteriaSb.length();
    }

    public ComposableWhereContext append(Where where) {
        if (where instanceof ComposableWhere) {
            ((ComposableWhere)ComposableWhere.class.cast(where)).visit(this);
            return this;
        }
        String criteria = where.getCriteria();
        if (StringUtil.isEmpty((String)criteria)) {
            return this;
        }
        this.append(criteria);
        for (Object param : where.getParams()) {
            this.addParam(param);
        }
        for (String propertyName : where.getPropertyNames()) {
            this.addPropertyName(propertyName);
        }
        return this;
    }

    public ComposableWhereContext append(boolean b) {
        this.criteriaSb.append(b);
        return this;
    }

    public ComposableWhereContext append(byte b) {
        this.criteriaSb.append(b);
        return this;
    }

    public ComposableWhereContext append(short s) {
        this.criteriaSb.append(s);
        return this;
    }

    public ComposableWhereContext append(int i) {
        this.criteriaSb.append(i);
        return this;
    }

    public ComposableWhereContext append(long l) {
        this.criteriaSb.append(l);
        return this;
    }

    public ComposableWhereContext append(float f) {
        this.criteriaSb.append(f);
        return this;
    }

    public ComposableWhereContext append(double d) {
        this.criteriaSb.append(d);
        return this;
    }

    public ComposableWhereContext append(char ch) {
        this.criteriaSb.append(ch);
        return this;
    }

    public ComposableWhereContext append(String s) {
        this.criteriaSb.append(s);
        return this;
    }

    public ComposableWhereContext append(Enum<?> e) {
        this.criteriaSb.append(e.getClass().getName()).append(".").append(e.name());
        return this;
    }

    public ComposableWhereContext append(Object o) {
        this.criteriaSb.append(o);
        return this;
    }

    public ComposableWhereContext cutBack(int number) {
        this.criteriaSb.setLength(this.criteriaSb.length() - number);
        return this;
    }

    public void addParam(Object param) {
        this.paramList.add(param);
    }

    public int addParam(ConditionType conditionType, Object param) {
        return conditionType.addValue(this.paramList, param);
    }

    public void addPropertyName(CharSequence propertyName) {
        this.propertyNameList.add(((Object)propertyName).toString());
    }
}

