/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util.tiger;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.exception.InvocationTargetRuntimeException;
import org.seasar.framework.exception.NoSuchConstructorRuntimeException;
import org.seasar.framework.exception.NoSuchFieldRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.tiger.GenericUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtil {
    protected ReflectionUtil() {
    }

    public static <T> Class<T> forName(String className) throws ClassNotFoundRuntimeException {
        return ReflectionUtil.forName(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forName(String className, ClassLoader loader) throws ClassNotFoundRuntimeException {
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }

    public static <T> Class<T> forNameNoException(String className) {
        return ReflectionUtil.forNameNoException(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forNameNoException(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... argTypes) throws NoSuchConstructorRuntimeException {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchConstructorRuntimeException(clazz, (Class[])argTypes, e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... argTypes) throws NoSuchConstructorRuntimeException {
        try {
            return clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchConstructorRuntimeException(clazz, (Class[])argTypes, e);
        }
    }

    public static Field getField(Class<?> clazz, String name) throws NoSuchFieldRuntimeException {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(clazz, name, e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldRuntimeException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(clazz, name, e);
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodRuntimeException {
        try {
            return clazz.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(clazz, name, (Class[])argTypes, e);
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodRuntimeException {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(clazz, name, (Class[])argTypes, e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(clazz, e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(constructor.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(constructor.getDeclaringClass(), e);
        }
    }

    public static <T> T getValue(Field field, Object target) throws IllegalAccessRuntimeException {
        try {
            return (T)field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), e);
        }
    }

    public static <T> T getStaticValue(Field field) throws IllegalAccessRuntimeException {
        return ReflectionUtil.getValue(field, null);
    }

    public static void setValue(Field field, Object target, Object value) throws IllegalAccessRuntimeException {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(field.getDeclaringClass(), e);
        }
    }

    public static void setStaticValue(Field field, Object value) throws IllegalAccessRuntimeException {
        ReflectionUtil.setValue(field, null, value);
    }

    public static <T> T invoke(Method method, Object target, Object ... args) throws IllegalAccessRuntimeException, InvocationTargetRuntimeException {
        try {
            return (T)method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(method.getDeclaringClass(), e);
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws IllegalAccessRuntimeException, InvocationTargetRuntimeException {
        return ReflectionUtil.invoke(method, null, args);
    }

    public static Class<?> getElementTypeOfCollection(Type parameterizedCollection) {
        return GenericUtil.getRawClass(GenericUtil.getElementTypeOfCollection(parameterizedCollection));
    }

    public static Class<?> getElementTypeOfCollectionFromFieldType(Field field) {
        Type type = field.getGenericType();
        return ReflectionUtil.getElementTypeOfCollection(type);
    }

    public static Class<?> getElementTypeOfCollectionFromParameterType(Method method, int parameterPosition) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        return ReflectionUtil.getElementTypeOfCollection(parameterTypes[parameterPosition]);
    }

    public static Class<?> getElementTypeOfCollectionFromReturnType(Method method) {
        return ReflectionUtil.getElementTypeOfCollection(method.getGenericReturnType());
    }

    public static Class<?> getElementTypeOfList(Type parameterizedList) {
        return GenericUtil.getRawClass(GenericUtil.getElementTypeOfList(parameterizedList));
    }

    public static Class<?> getElementTypeOfListFromFieldType(Field field) {
        Type type = field.getGenericType();
        return ReflectionUtil.getElementTypeOfList(type);
    }

    public static Class<?> getElementTypeOfListFromParameterType(Method method, int parameterPosition) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        return ReflectionUtil.getElementTypeOfList(parameterTypes[parameterPosition]);
    }

    public static Class<?> getElementTypeOfListFromReturnType(Method method) {
        return ReflectionUtil.getElementTypeOfList(method.getGenericReturnType());
    }

    public static Class<?> getElementTypeOfSet(Type parameterizedSet) {
        return GenericUtil.getRawClass(GenericUtil.getElementTypeOfSet(parameterizedSet));
    }

    public static Class<?> getElementTypeOfSetFromFieldType(Field field) {
        Type type = field.getGenericType();
        return ReflectionUtil.getElementTypeOfSet(type);
    }

    public static Class<?> getElementTypeOfSetFromParameterType(Method method, int parameterPosition) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        return ReflectionUtil.getElementTypeOfSet(parameterTypes[parameterPosition]);
    }

    public static Class<?> getElementTypeOfSetFromReturnType(Method method) {
        return ReflectionUtil.getElementTypeOfSet(method.getGenericReturnType());
    }
}

