/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runners.AllTests;

public class AllTestsTest {
    private static boolean run;

    @Test
    public void ensureTestIsRun() {
        JUnitCore runner = new JUnitCore();
        run = false;
        runner.run(All.class);
        Assert.assertTrue(run);
    }

    @Test
    public void correctTestCount() throws Throwable {
        AllTests tests = new AllTests(All.class);
        Assert.assertEquals(1, tests.testCount());
    }

    @Test
    public void correctTestCountAdapted() throws Throwable {
        AllTests tests = new AllTests(AllJUnit4.class);
        Assert.assertEquals(1, tests.testCount());
    }

    @Test(expected=RuntimeException.class)
    public void exceptionThrownWhenSuiteIsBad() throws Throwable {
        new AllTests(BadSuiteMethod.class);
    }

    @RunWith(value=AllTests.class)
    public static class BadSuiteMethod {
        public static junit.framework.Test suite() {
            throw new RuntimeException("can't construct");
        }
    }

    @RunWith(value=AllTests.class)
    public static class AllJUnit4 {
        public static junit.framework.Test suite() {
            TestSuite suite = new TestSuite();
            suite.addTest(new JUnit4TestAdapter(JUnit4Test.class));
            return suite;
        }
    }

    public static class JUnit4Test {
        @Test
        public void testSomething() {
            run = true;
        }
    }

    @RunWith(value=AllTests.class)
    public static class All {
        public static junit.framework.Test suite() {
            TestSuite suite = new TestSuite();
            suite.addTestSuite(OneTest.class);
            return suite;
        }
    }

    public static class OneTest
    extends TestCase {
        public void testSomething() {
            run = true;
        }
    }
}

