/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.junit.internal.ArrayComparisonFailure;

public class AssertionTest {
    @Test(expected=AssertionError.class)
    public void fails() {
        Assert.fail();
    }

    @Test(expected=AssertionError.class)
    public void arraysNotEqual() {
        Assert.assertArrayEquals(new Object[]{new Object()}, new Object[]{new Object()});
    }

    @Test(expected=AssertionError.class)
    public void arraysNotEqualWithMessage() {
        Assert.assertArrayEquals("not equal", new Object[]{new Object()}, new Object[]{new Object()});
    }

    @Test
    public void arraysExpectedNullMessage() {
        try {
            Assert.assertArrayEquals("not equal", null, new Object[]{new Object()});
        }
        catch (AssertionError exception) {
            Assert.assertEquals("not equal: expected array was null", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void arraysActualNullMessage() {
        try {
            Assert.assertArrayEquals("not equal", new Object[]{new Object()}, null);
        }
        catch (AssertionError exception) {
            Assert.assertEquals("not equal: actual array was null", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void arraysDifferentLengthMessage() {
        try {
            Assert.assertArrayEquals("not equal", new Object[0], new Object[1]);
        }
        catch (AssertionError exception) {
            Assert.assertEquals("not equal: array lengths differed, expected.length=0 actual.length=1", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test(expected=ArrayComparisonFailure.class)
    public void arraysElementsDiffer() {
        Assert.assertArrayEquals("not equal", new Object[]{"this is a very long string in the middle of an array"}, new Object[]{"this is another very long string in the middle of an array"});
    }

    @Test
    public void arraysDifferAtElement0nullMessage() {
        try {
            Assert.assertArrayEquals(new Object[]{true}, new Object[]{false});
        }
        catch (AssertionError exception) {
            Assert.assertEquals("arrays first differed at element [0]; expected:<true> but was:<false>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void arraysDifferAtElement1nullMessage() {
        try {
            Assert.assertArrayEquals(new Object[]{true, true}, new Object[]{true, false});
        }
        catch (AssertionError exception) {
            Assert.assertEquals("arrays first differed at element [1]; expected:<true> but was:<false>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void arraysDifferAtElement0withMessage() {
        try {
            Assert.assertArrayEquals("message", new Object[]{true}, new Object[]{false});
        }
        catch (AssertionError exception) {
            Assert.assertEquals("message: arrays first differed at element [0]; expected:<true> but was:<false>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void arraysDifferAtElement1withMessage() {
        try {
            Assert.assertArrayEquals("message", new Object[]{true, true}, new Object[]{true, false});
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("message: arrays first differed at element [1]; expected:<true> but was:<false>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void multiDimensionalArraysAreEqual() {
        Assert.assertArrayEquals((Object[])new Object[][]{{true, true}, {false, false}}, (Object[])new Object[][]{{true, true}, {false, false}});
    }

    @Test
    public void multiDimensionalIntArraysAreEqual() {
        int[][] int1 = new int[][]{{1, 2, 3}, {4, 5, 6}};
        int[][] int2 = new int[][]{{1, 2, 3}, {4, 5, 6}};
        Assert.assertArrayEquals((Object[])int1, (Object[])int2);
    }

    @Test
    public void oneDimensionalPrimitiveArraysAreEqual() {
        Assert.assertArrayEquals(new byte[]{1}, new byte[]{1});
        Assert.assertArrayEquals(new char[]{'\u0001'}, new char[]{'\u0001'});
        Assert.assertArrayEquals(new short[]{1}, new short[]{1});
        Assert.assertArrayEquals(new int[]{1}, new int[]{1});
        Assert.assertArrayEquals(new long[]{1L}, new long[]{1L});
    }

    @Test
    public void arraysContainingIntsAreEqualToArraysContainingLongs() {
        Object[] int1 = new Object[]{1, 2, 3};
        Object[] int2 = new Object[]{1L, 2L, 3L};
        Assert.assertArrayEquals(int1, int2);
    }

    @Test
    public void intsEqualLongs() {
        Assert.assertEquals(1, 1L);
    }

    @Test
    public void multiDimensionalArraysDeclaredAsOneDimensionalAreEqual() {
        Assert.assertArrayEquals(new Object[]{new Object[]{true, true}, new Object[]{false, false}}, new Object[]{new Object[]{true, true}, new Object[]{false, false}});
    }

    @Test
    public void multiDimensionalArraysAreNotEqual() {
        try {
            Assert.assertArrayEquals("message", (Object[])new Object[][]{{true, true}, {false, false}}, (Object[])new Object[][]{{true, true}, {true, false}});
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("message: arrays first differed at element [1][0]; expected:<false> but was:<true>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void multiDimensionalArraysAreNotEqualNoMessage() {
        try {
            Assert.assertArrayEquals((Object[])new Object[][]{{true, true}, {false, false}}, (Object[])new Object[][]{{true, true}, {true, false}});
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("arrays first differed at element [1][0]; expected:<false> but was:<true>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void arraysWithNullElementEqual() {
        Object[] objects1 = new Object[]{null};
        Object[] objects2 = new Object[]{null};
        Assert.assertArrayEquals(objects1, objects2);
    }

    @Test
    public void stringsDifferWithUserMessage() {
        try {
            Assert.assertEquals("not equal", "one", "two");
        }
        catch (Throwable exception) {
            Assert.assertEquals("not equal expected:<[one]> but was:<[two]>", exception.getMessage());
        }
    }

    @Test
    public void arraysEqual() {
        Object element = new Object();
        Object[] objects1 = new Object[]{element};
        Object[] objects2 = new Object[]{element};
        Assert.assertArrayEquals(objects1, objects2);
    }

    @Test
    public void arraysEqualWithMessage() {
        Object element = new Object();
        Object[] objects1 = new Object[]{element};
        Object[] objects2 = new Object[]{element};
        Assert.assertArrayEquals("equal", objects1, objects2);
    }

    @Test
    public void equals() {
        Object o = new Object();
        Assert.assertEquals(o, o);
        Assert.assertEquals("abc", "abc");
        Assert.assertEquals(true, true);
        Assert.assertEquals((byte)1, (byte)1);
        Assert.assertEquals(Character.valueOf('a'), Character.valueOf('a'));
        Assert.assertEquals((short)1, (short)1);
        Assert.assertEquals(1, 1);
        Assert.assertEquals(1L, 1L);
        Assert.assertEquals(1.0, 1.0, 0.0);
        Assert.assertEquals(1.0, 1.0, 0.0);
    }

    @Test(expected=AssertionError.class)
    public void objectsNotEquals() {
        Assert.assertEquals(new Object(), new Object());
    }

    @Test(expected=ComparisonFailure.class)
    public void stringsNotEqual() {
        Assert.assertEquals("abc", "def");
    }

    @Test(expected=AssertionError.class)
    public void booleansNotEqual() {
        Assert.assertEquals(true, false);
    }

    @Test(expected=AssertionError.class)
    public void bytesNotEqual() {
        Assert.assertEquals((byte)1, (byte)2);
    }

    @Test(expected=AssertionError.class)
    public void charsNotEqual() {
        Assert.assertEquals(Character.valueOf('a'), Character.valueOf('b'));
    }

    @Test(expected=AssertionError.class)
    public void shortsNotEqual() {
        Assert.assertEquals((short)1, (short)2);
    }

    @Test(expected=AssertionError.class)
    public void intsNotEqual() {
        Assert.assertEquals(1, 2);
    }

    @Test(expected=AssertionError.class)
    public void longsNotEqual() {
        Assert.assertEquals(1L, 2L);
    }

    @Test(expected=AssertionError.class)
    public void floatsNotEqual() {
        Assert.assertEquals(1.0, 2.0, 0.9);
    }

    @Test(expected=AssertionError.class)
    public void doublesNotEqual() {
        Assert.assertEquals(1.0, 2.0, 0.9);
    }

    @Test
    public void naNsAreEqual() {
        Assert.assertEquals(Double.NaN, Double.NaN, Double.POSITIVE_INFINITY);
        Assert.assertEquals(Double.NaN, Double.NaN, Double.POSITIVE_INFINITY);
    }

    @Test
    public void same() {
        Object o1 = new Object();
        Assert.assertSame(o1, o1);
    }

    @Test
    public void notSame() {
        Object o1 = new Object();
        Object o2 = new Object();
        Assert.assertNotSame(o1, o2);
    }

    @Test(expected=AssertionError.class)
    public void objectsNotSame() {
        Assert.assertSame(new Object(), new Object());
    }

    @Test(expected=AssertionError.class)
    public void objectsAreSame() {
        Object o = new Object();
        Assert.assertNotSame(o, o);
    }

    @Test
    public void sameWithMessage() {
        try {
            Assert.assertSame("not same", "hello", "good-bye");
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("not same expected same:<hello> was not:<good-bye>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void sameNullMessage() {
        try {
            Assert.assertSame("hello", "good-bye");
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("expected same:<hello> was not:<good-bye>", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void notSameWithMessage() {
        Object o = new Object();
        try {
            Assert.assertNotSame("message", o, o);
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("message expected not same", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void notSameNullMessage() {
        Object o = new Object();
        try {
            Assert.assertNotSame(o, o);
            Assert.fail();
        }
        catch (AssertionError exception) {
            Assert.assertEquals("expected not same", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void nullMessage() {
        try {
            Assert.fail(null);
        }
        catch (AssertionError exception) {
            Assert.assertEquals("", ((Throwable)((Object)exception)).getMessage());
        }
    }

    @Test
    public void nullMessageDisappearsWithStringAssertEquals() {
        try {
            Assert.assertEquals(null, "a", "b");
            Assert.fail();
        }
        catch (ComparisonFailure e) {
            Assert.assertEquals("expected:<[a]> but was:<[b]>", e.getMessage());
        }
    }

    @Test
    public void nullMessageDisappearsWithAssertEquals() {
        try {
            Assert.assertEquals(null, (Object)1, (Object)2);
            Assert.fail();
        }
        catch (AssertionError e) {
            Assert.assertEquals("expected:<1> but was:<2>", ((Throwable)((Object)e)).getMessage());
        }
    }

    @Test(expected=AssertionError.class)
    public void arraysDeclaredAsObjectAreComparedAsObjects() {
        Object[] a1 = new Object[]{"abc"};
        Object[] a2 = new Object[]{"abc"};
        Assert.assertEquals((Object)a1, (Object)a2);
    }

    @Test
    public void implicitTypecastEquality() {
        byte b = 1;
        short s = 1;
        int i = 1;
        long l = 1L;
        float f = 1.0f;
        double d = 1.0;
        Assert.assertEquals(b, s);
        Assert.assertEquals(b, i);
        Assert.assertEquals(b, l);
        Assert.assertEquals(s, i);
        Assert.assertEquals(s, l);
        Assert.assertEquals(i, l);
        Assert.assertEquals(f, d, 0.0);
    }

    @Test
    public void errorMessageDistinguishesDifferentValuesWithSameToString() {
        try {
            Assert.assertEquals("4", new Integer(4));
        }
        catch (AssertionError e) {
            Assert.assertEquals("expected: java.lang.String<4> but was: java.lang.Integer<4>", ((Throwable)((Object)e)).getMessage());
        }
    }
}

