/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestResult;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runners.Suite;

public class SuiteTest {
    private static String log = "";

    @Test
    public void ensureTestIsRun() {
        JUnitCore core = new JUnitCore();
        Result result = core.run(All.class);
        Assert.assertEquals(2, result.getRunCount());
        Assert.assertEquals(1, result.getFailureCount());
    }

    @Test
    public void suiteTestCountIsCorrect() throws Exception {
        Runner runner = Request.aClass(All.class).getRunner();
        Assert.assertEquals(2, runner.testCount());
    }

    @Test
    public void ensureSuitesWorkWithForwardCompatibility() {
        JUnit4TestAdapter test = new JUnit4TestAdapter(All.class);
        TestResult result = new TestResult();
        test.run(result);
        Assert.assertEquals(2, result.runCount());
    }

    @Test
    public void forwardCompatibilityWorksWithGetTests() {
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(All.class);
        List<junit.framework.Test> tests = adapter.getTests();
        Assert.assertEquals(2, tests.size());
    }

    @Test
    public void forwardCompatibilityWorksWithTestCount() {
        JUnit4TestAdapter adapter = new JUnit4TestAdapter(All.class);
        Assert.assertEquals(2, adapter.countTestCases());
    }

    @Test
    public void beforeAndAfterClassRunOnSuite() {
        log = "";
        JUnitCore.runClasses(AllWithBeforeAndAfterClass.class);
        Assert.assertEquals("before after ", log);
    }

    @Test
    public void withoutSuiteClassAnnotationProducesFailure() {
        Result result = JUnitCore.runClasses(AllWithOutAnnotation.class);
        Assert.assertEquals(1, result.getFailureCount());
        String expected = String.format("class '%s' must have a SuiteClasses annotation", AllWithOutAnnotation.class.getName());
        Assert.assertEquals(expected, result.getFailures().get(0).getMessage());
    }

    @Test
    public void whatHappensWhenASuiteHasACycle() {
        Result result = JUnitCore.runClasses(InfiniteLoop.class);
        Assert.assertEquals(1, result.getFailureCount());
    }

    @Test
    public void whatHappensWhenASuiteHasAForkingCycle() {
        Result result = JUnitCore.runClasses(BiInfiniteLoop.class);
        Assert.assertEquals(2, result.getFailureCount());
    }

    @Test
    public void whatHappensWhenASuiteContainsItselfIndirectly() {
        Result result = JUnitCore.runClasses(Hydra.class);
        Assert.assertEquals(2, result.getFailureCount());
    }

    @Test
    public void suiteShouldBeOKwithNonDefaultConstructor() throws Exception {
        Result result = JUnitCore.runClasses(WithoutDefaultConstructor.class);
        Assert.assertTrue(result.wasSuccessful());
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={})
    public class WithoutDefaultConstructor {
        public WithoutDefaultConstructor(int i) {
        }
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={Hydra.class, Hydra.class})
    public static class Hercules {
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={Hercules.class})
    public static class Hydra {
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={BiInfiniteLoop.class, BiInfiniteLoop.class})
    public static class BiInfiniteLoop {
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={InfiniteLoop.class})
    public static class InfiniteLoop {
    }

    @RunWith(value=Suite.class)
    public static class AllWithOutAnnotation {
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={TestA.class, TestB.class})
    public static class AllWithBeforeAndAfterClass {
        @BeforeClass
        public static void before() {
            log = log + "before ";
        }

        @AfterClass
        public static void after() {
            log = log + "after ";
        }
    }

    @RunWith(value=Suite.class)
    @Suite.SuiteClasses(value={TestA.class, TestB.class})
    public static class All {
    }

    public static class TestB {
        @Test
        public void fail() {
            Assert.fail();
        }
    }

    public static class TestA {
        @Test
        public void pass() {
        }
    }
}

