/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.MultiSegmentReader;
import org.apache.lucene.index.ReadOnlyMultiSegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;

abstract class DirectoryIndexReader
extends IndexReader {
    protected Directory directory;
    protected boolean closeDirectory;
    private IndexDeletionPolicy deletionPolicy;
    private SegmentInfos segmentInfos;
    private Lock writeLock;
    private boolean stale;
    private final HashSet synced = new HashSet();
    private boolean rollbackHasChanges;
    private SegmentInfos rollbackSegmentInfos;
    protected boolean readOnly;
    static final /* synthetic */ boolean $assertionsDisabled;

    void init(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory, boolean readOnly) throws IOException {
        this.directory = directory;
        this.segmentInfos = segmentInfos;
        this.closeDirectory = closeDirectory;
        this.readOnly = readOnly;
        if (!readOnly && segmentInfos != null) {
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo info = segmentInfos.info(i);
                List files = info.files();
                for (int j = 0; j < files.size(); ++j) {
                    this.synced.add(files.get(j));
                }
            }
        }
    }

    protected DirectoryIndexReader() {
    }

    DirectoryIndexReader(Directory directory, SegmentInfos segmentInfos, boolean closeDirectory, boolean readOnly) throws IOException {
        this.init(directory, segmentInfos, closeDirectory, readOnly);
    }

    static DirectoryIndexReader open(Directory directory, boolean closeDirectory, IndexDeletionPolicy deletionPolicy) throws CorruptIndexException, IOException {
        return DirectoryIndexReader.open(directory, closeDirectory, deletionPolicy, null, false);
    }

    static DirectoryIndexReader open(Directory directory, final boolean closeDirectory, final IndexDeletionPolicy deletionPolicy, IndexCommit commit, final boolean readOnly) throws CorruptIndexException, IOException {
        SegmentInfos.FindSegmentsFile finder = new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                DirectoryIndexReader reader = infos.size() == 1 ? SegmentReader.get(readOnly, infos, infos.info(0), closeDirectory) : (readOnly ? new ReadOnlyMultiSegmentReader(this.directory, infos, closeDirectory) : new MultiSegmentReader(this.directory, infos, closeDirectory, false));
                reader.setDeletionPolicy(deletionPolicy);
                return reader;
            }
        };
        if (commit == null) {
            return (DirectoryIndexReader)finder.run();
        }
        if (directory != commit.getDirectory()) {
            throw new IOException("the specified commit does not match the specified Directory");
        }
        return (DirectoryIndexReader)finder.doBody(commit.getSegmentsFileName());
    }

    public final synchronized IndexReader reopen() throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.hasChanges || this.isCurrent()) {
            return this;
        }
        return (DirectoryIndexReader)new SegmentInfos.FindSegmentsFile(this.directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                DirectoryIndexReader newReader = DirectoryIndexReader.this.doReopen(infos);
                if (DirectoryIndexReader.this != newReader) {
                    newReader.init(this.directory, infos, DirectoryIndexReader.this.closeDirectory, DirectoryIndexReader.this.readOnly);
                    newReader.deletionPolicy = DirectoryIndexReader.this.deletionPolicy;
                }
                return newReader;
            }
        }.run();
    }

    protected abstract DirectoryIndexReader doReopen(SegmentInfos var1) throws CorruptIndexException, IOException;

    public void setDeletionPolicy(IndexDeletionPolicy deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
    }

    public Directory directory() {
        this.ensureOpen();
        return this.directory;
    }

    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        return SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
    }

    public boolean isOptimized() {
        this.ensureOpen();
        return this.segmentInfos.size() == 1 && !this.hasDeletions();
    }

    protected void doClose() throws IOException {
        if (this.closeDirectory) {
            this.directory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() throws IOException {
        if (this.hasChanges) {
            if (this.segmentInfos != null) {
                IndexFileDeleter deleter = new IndexFileDeleter(this.directory, this.deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : this.deletionPolicy, this.segmentInfos, null, null);
                this.startCommit();
                boolean success = false;
                try {
                    this.commitChanges();
                    for (int i = 0; i < this.segmentInfos.size(); ++i) {
                        SegmentInfo info = this.segmentInfos.info(i);
                        List files = info.files();
                        for (int j = 0; j < files.size(); ++j) {
                            String fileName = (String)files.get(j);
                            if (this.synced.contains(fileName)) continue;
                            if (!$assertionsDisabled && !this.directory.fileExists(fileName)) {
                                throw new AssertionError();
                            }
                            this.directory.sync(fileName);
                            this.synced.add(fileName);
                        }
                    }
                    this.segmentInfos.commit(this.directory);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.rollbackCommit();
                        deleter.refresh();
                    }
                }
                deleter.checkpoint(this.segmentInfos, true);
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            } else {
                this.commitChanges();
            }
        }
        this.hasChanges = false;
    }

    protected abstract void commitChanges() throws IOException;

    protected void acquireWriteLock() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.segmentInfos != null) {
            this.ensureOpen();
            if (this.stale) {
                throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
            if (this.writeLock == null) {
                Lock writeLock = this.directory.makeLock("write.lock");
                if (!writeLock.obtain(IndexWriter.WRITE_LOCK_TIMEOUT)) {
                    throw new LockObtainFailedException("Index locked for write: " + writeLock);
                }
                this.writeLock = writeLock;
                if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                    this.stale = true;
                    this.writeLock.release();
                    this.writeLock = null;
                    throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
                }
            }
        }
    }

    void startCommit() {
        if (this.segmentInfos != null) {
            this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        }
        this.rollbackHasChanges = this.hasChanges;
    }

    void rollbackCommit() {
        if (this.segmentInfos != null) {
            for (int i = 0; i < this.segmentInfos.size(); ++i) {
                this.segmentInfos.info(i).reset(this.rollbackSegmentInfos.info(i));
            }
            this.rollbackSegmentInfos = null;
        }
        this.hasChanges = this.rollbackHasChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public IndexCommit getIndexCommit() throws IOException {
        return new ReaderCommit(this.segmentInfos, this.directory);
    }

    public static Collection listCommits(Directory dir) throws IOException {
        String[] files = dir.list();
        if (files == null) {
            throw new IOException("cannot read directory " + dir + ": list() returned null");
        }
        ArrayList<ReaderCommit> commits = new ArrayList<ReaderCommit>();
        SegmentInfos latest = new SegmentInfos();
        latest.read(dir);
        long currentGen = latest.getGeneration();
        commits.add(new ReaderCommit(latest, dir));
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!fileName.startsWith("segments") || fileName.equals("segments.gen") || SegmentInfos.generationFromSegmentsFileName(fileName) >= currentGen) continue;
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(dir, fileName);
            }
            catch (FileNotFoundException fnfe) {
                sis = null;
            }
            if (sis == null) continue;
            commits.add(new ReaderCommit(sis, dir));
        }
        return commits;
    }

    static {
        $assertionsDisabled = !DirectoryIndexReader.class.desiredAssertionStatus();
    }

    private static class ReaderCommit
    extends IndexCommit {
        private String segmentsFileName;
        Collection files;
        Directory dir;
        long generation;
        long version;
        final boolean isOptimized;

        ReaderCommit(SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getCurrentSegmentFileName();
            this.dir = dir;
            int size = infos.size();
            this.files = new ArrayList(size);
            this.files.add(this.segmentsFileName);
            for (int i = 0; i < size; ++i) {
                SegmentInfo info = infos.info(i);
                if (info.dir != dir) continue;
                this.files.addAll(info.files());
            }
            this.version = infos.getVersion();
            this.generation = infos.getGeneration();
            this.isOptimized = infos.size() == 1 && !infos.info(0).hasDeletions();
        }

        public boolean isOptimized() {
            return this.isOptimized;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection getFileNames() {
            return this.files;
        }

        public Directory getDirectory() {
            return this.dir;
        }

        public long getVersion() {
            return this.version;
        }

        public long getGeneration() {
            return this.generation;
        }

        public boolean isDeleted() {
            return false;
        }
    }
}

