/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.device.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.device.Device;
import org.mobylet.core.device.DeviceDisplay;
import org.mobylet.core.device.DeviceProfile;
import org.mobylet.core.device.DeviceReader;
import org.mobylet.core.device.impl.MobyletDevice;
import org.mobylet.core.util.CSVSplitUtils;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.SingletonUtils;

public class ValueEngineDeviceReader
implements DeviceReader {
    public String pathUserAgent = "UserAgent.csv";
    public String pathProfile = "ProfileData.csv";
    public String pathDisplay = "DisplayInfo.csv";

    @Override
    public synchronized Map<String, Device> read() {
        HashMap<String, Device> dvMap = new HashMap<String, Device>(1024);
        Map<String, List<String>> uaMap = this.readUserAgent();
        Map<String, DeviceProfile> pfMap = this.readProfileData(uaMap);
        Map<String, DeviceDisplay> diMap = this.readDisplayInfo(uaMap);
        Set<Map.Entry<String, DeviceProfile>> entrySet = pfMap.entrySet();
        for (Map.Entry<String, DeviceProfile> entry : entrySet) {
            MobyletDevice d = new MobyletDevice();
            d.setDeviceProfile(entry.getValue());
            d.setDeviceDisplay(diMap.get(entry.getKey()));
            dvMap.put(entry.getKey(), d);
        }
        return dvMap;
    }

    protected Map<String, List<String>> readUserAgent() {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        BufferedReader reader = null;
        HashMap<String, List<String>> uaMap = new HashMap<String, List<String>>();
        String[] header = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceFileOrInputStream(config.getDeviceDir() + this.pathUserAgent), "windows-31j"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (header == null) {
                    header = CSVSplitUtils.splitLineToArray(line);
                    continue;
                }
                String[] val = CSVSplitUtils.splitLineToArray(line);
                String key = val[0] + "/" + val[1];
                ArrayList<String> uaSet = (ArrayList<String>)uaMap.get(key);
                if (uaSet == null) {
                    uaSet = new ArrayList<String>();
                    uaSet.add(val[3]);
                    uaMap.put(key, uaSet);
                    continue;
                }
                uaSet.add(val[3]);
            }
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return uaMap;
    }

    protected Map<String, DeviceProfile> readProfileData(Map<String, List<String>> uaMap) {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        BufferedReader reader = null;
        HashMap<String, DeviceProfile> dpMap = new HashMap<String, DeviceProfile>();
        String[] header = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceFileOrInputStream(config.getDeviceDir() + this.pathProfile), "windows-31j"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (header == null) {
                    header = CSVSplitUtils.splitLineToArray(line);
                    continue;
                }
                String[] val = CSVSplitUtils.splitLineToArray(line);
                DeviceProfile dp = new DeviceProfile();
                for (int i = 0; i < val.length; ++i) {
                    dp.put(header[i], val[i]);
                }
                List<String> uaSet = uaMap.get(val[0] + "/" + val[1]);
                if (uaSet == null) continue;
                for (String ua : uaSet) {
                    dpMap.put(ua, dp);
                }
            }
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return dpMap;
    }

    protected Map<String, DeviceDisplay> readDisplayInfo(Map<String, List<String>> uaMap) {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        BufferedReader reader = null;
        HashMap<String, DeviceDisplay> diMap = new HashMap<String, DeviceDisplay>();
        String[] header = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ResourceUtils.getResourceFileOrInputStream(config.getDeviceDir() + this.pathDisplay), "windows-31j"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                DeviceDisplay pdd;
                DeviceDisplay dd;
                if (header == null) {
                    header = CSVSplitUtils.splitLineToArray(line);
                    continue;
                }
                String[] val = CSVSplitUtils.splitLineToArray(line);
                List<String> keys = uaMap.get(val[0] + "/" + val[1]);
                if (keys == null) continue;
                if ("\u30d6\u30e9\u30a6\u30b6\u753b\u50cf\u30b5\u30a4\u30ba".equals(val[2])) {
                    if (diMap.get(keys.get(0)) == null) {
                        dd = new DeviceDisplay();
                        dd.setWidth(new Integer(val[3]));
                        dd.setHeight(new Integer(val[4]));
                        for (String key : keys) {
                            diMap.put(key, dd);
                        }
                        continue;
                    }
                    dd = (DeviceDisplay)diMap.get(keys.get(0));
                    dd.setWidth(new Integer(val[3]));
                    dd.setHeight(new Integer(val[4]));
                    continue;
                }
                dd = new DeviceDisplay();
                dd.setWidth(new Integer(val[3]));
                dd.setHeight(new Integer(val[4]));
                if (diMap.get(keys.get(0)) == null) {
                    pdd = new DeviceDisplay();
                    pdd.putAnotherDisplay(val[2], dd);
                    for (String key : keys) {
                        diMap.put(key, pdd);
                    }
                    continue;
                }
                pdd = (DeviceDisplay)diMap.get(keys.get(0));
                pdd.putAnotherDisplay(val[2], dd);
            }
        }
        catch (IOException e) {
            throw new MobyletRuntimeException("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return diMap;
    }
}

