/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.session.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.holder.SessionHolder;
import org.mobylet.core.holder.impl.MobyletSessionHolder;
import org.mobylet.core.session.MobyletSession;
import org.mobylet.core.util.RequestUtils;

public class MobyletSessionImpl
implements MobyletSession {
    public static final String KEY_HOLDER = SessionHolder.class.getName();
    protected Class<? extends SessionHolder> holderClass = MobyletSessionHolder.class;

    @Override
    public boolean exist() {
        Object holder;
        HttpServletRequest request = RequestUtils.get();
        HttpSession session = request.getSession(false);
        return session != null && (holder = session.getAttribute(KEY_HOLDER)) != null && holder instanceof SessionHolder;
    }

    @Override
    public <T> T get(Class<T> clazz) {
        if (clazz != null) {
            return this.get(clazz.getName());
        }
        return null;
    }

    @Override
    public <T> T get(String key) {
        Object holder;
        HttpServletRequest request = RequestUtils.get();
        HttpSession session = request.getSession(false);
        if (session != null && (holder = session.getAttribute(KEY_HOLDER)) != null && holder instanceof SessionHolder) {
            return ((SessionHolder)SessionHolder.class.cast(holder)).get(key);
        }
        return null;
    }

    @Override
    public void invalidate() {
        HttpServletRequest request = RequestUtils.get();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    @Override
    public <T> T remove(Class<T> clazz) {
        if (clazz != null) {
            return this.remove(clazz.getName());
        }
        return null;
    }

    @Override
    public <T> T remove(String key) {
        Object holder;
        HttpServletRequest request = RequestUtils.get();
        HttpSession session = request.getSession(false);
        if (session != null && (holder = session.getAttribute(KEY_HOLDER)) != null && holder instanceof SessionHolder) {
            return ((SessionHolder)SessionHolder.class.cast(holder)).remove(key);
        }
        return null;
    }

    @Override
    public <T> void set(T obj) {
        if (obj != null) {
            this.set(obj.getClass().getName(), obj);
        }
    }

    @Override
    public <T> void set(String key, T obj) {
        HttpServletRequest request = RequestUtils.get();
        HttpSession session = request.getSession(true);
        Object holder = session.getAttribute(KEY_HOLDER);
        if (holder == null || !(holder instanceof SessionHolder)) {
            try {
                holder = this.holderClass.newInstance();
            }
            catch (Exception e) {
                throw new MobyletRuntimeException("SessionHolder\u304c\u751f\u6210\u51fa\u6765\u307e\u305b\u3093 holder = " + this.holderClass.getName(), e);
            }
        }
        ((SessionHolder)SessionHolder.class.cast(holder)).set(key, obj);
        session.setAttribute(KEY_HOLDER, holder);
    }

    @Override
    public void substitute() {
        if (this.exist()) {
            HttpServletRequest request = RequestUtils.get();
            HttpSession session = request.getSession(false);
            Object holder = session.getAttribute(KEY_HOLDER);
            this.invalidate();
            session = request.getSession(true);
            session.setAttribute(KEY_HOLDER, holder);
        }
    }
}

