/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mobylet.core.config.enums.ConfigKeyword;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class ConfigUtils {
    public static final Pattern PAT_VARIABLE = Pattern.compile("[$]{1}[{]{1}[a-zA-Z0-9_.]+[}]{1}");

    public static String parseValue(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        FilterConfig filterConfig = SingletonUtils.get(FilterConfig.class);
        ServletContext servletContext = SingletonUtils.get(ServletContext.class);
        Matcher matcher = PAT_VARIABLE.matcher(value);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            Object obj;
            String matchedSeq = matcher.group();
            String word = matchedSeq.substring(2, matchedSeq.length() - 1);
            String parsedVal = "";
            if (filterConfig != null) {
                parsedVal = filterConfig.getInitParameter(word);
            }
            if (StringUtils.isEmpty(parsedVal) && servletContext != null && StringUtils.isEmpty(parsedVal = ConfigUtils.getKeywordValue(word, servletContext)) && (obj = servletContext.getAttribute(word)) != null) {
                parsedVal = obj.toString();
            }
            if (StringUtils.isEmpty(parsedVal)) {
                parsedVal = System.getProperty(word);
            }
            if (StringUtils.isNotEmpty(parsedVal)) {
                parsedVal = StringUtils.escape(parsedVal);
            }
            matcher.appendReplacement(buf, parsedVal);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    protected static String getKeywordValue(String value, ServletContext servletContext) {
        block6: for (ConfigKeyword keyword : ConfigKeyword.values()) {
            if (!value.equals(keyword.getKeyword())) continue;
            switch (keyword) {
                case CONTEXT_PATH: {
                    try {
                        Method method = ServletContext.class.getMethod("getContextPath", new Class[0]);
                        Object obj = method.invoke((Object)servletContext, new Object[0]);
                        if (obj == null) continue block6;
                        return obj.toString();
                    }
                    catch (Exception e) {}
                    continue block6;
                }
                case DOC_BASE: {
                    return servletContext.getRealPath("");
                }
            }
        }
        return null;
    }
}

