/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.http.MobyletFilter;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlEncoder;

public class UrlUtils {
    public static String Q = "?";
    public static String AMP = "&";
    public static String EQ = "=";
    public static String SC = ";";
    public static String SP = "#";

    public static String addParameter(String url, String pKey, String pValue) {
        return UrlUtils.addParameter(url, pKey, pValue, true);
    }

    public static String addParameter(String url, String pKey, String pValue, boolean sanitize) {
        if (StringUtils.isEmpty(pKey)) {
            return url;
        }
        String encodedValue = null;
        encodedValue = sanitize ? UrlUtils.encodeUrl(pValue) : pValue;
        if (StringUtils.isNotEmpty(url)) {
            if (url.contains(Q)) {
                return url + AMP + pKey + EQ + encodedValue;
            }
            return url + Q + pKey + EQ + encodedValue;
        }
        return Q + pKey + EQ + encodedValue;
    }

    public static String encodeUrl(String url) {
        Charset charset = MobyletFactory.getInstance().getDialect().getCharset();
        String encodedUrl = null;
        encodedUrl = url == null ? "" : UrlEncoder.encode(url, charset);
        return encodedUrl;
    }

    public static String addSession(String url, String sessionId) {
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(Q);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(SP)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(SC);
            sb.append("jsessionid");
            sb.append(EQ);
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public static String getCurrentUrl() {
        HttpServletRequest request = RequestUtils.get();
        if (request == null) {
            return null;
        }
        String url = null;
        MobyletFilter.NativeUrl nativeUrl = null;
        nativeUrl = RequestUtils.getMobyletContext().get(MobyletFilter.NativeUrl.class);
        url = nativeUrl != null ? nativeUrl.getUrl() : request.getRequestURL().toString();
        if (request.isSecure() && url.startsWith("http:")) {
            url = url.replace("http:", "https;");
        }
        return url;
    }
}

