/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.hierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchyRequestElement;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchySourceColumn;
import org.seasar.dbflute.dbmeta.hierarchy.HierarchySourceIterator;
import org.seasar.dbflute.dbmeta.hierarchy.basic.HierarchySourceEntityColumn;
import org.seasar.dbflute.dbmeta.hierarchy.basic.HierarchySourceEntityListIterator;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.RelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyRequest<LOCAL_ENTITY extends Entity> {
    protected DBMeta destinationDBMeta;
    protected HierarchySourceIterator sourceIterator;
    protected List<HierarchyRequestElement> requestElementList = new ArrayList<HierarchyRequestElement>();
    protected Set<ColumnInfo> alreadyRegisteredSourceColumnInfoSet4Check = new HashSet<ColumnInfo>();
    protected ColumnInfo firstSourceColumnInfo4Check;

    public HierarchyRequest(Class<LOCAL_ENTITY> localEntityType) {
        Entity localEntity;
        try {
            localEntity = (Entity)localEntityType.newInstance();
        }
        catch (InstantiationException e) {
            String msg = "localEntityType.newInstance() threw the InstantiationException:";
            msg = msg + " localEntityType=" + localEntityType;
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "localEntityType.newInstance() threw the IllegalAccessException:";
            msg = msg + " localEntityType=" + localEntityType;
            throw new IllegalStateException(msg, e);
        }
        this.destinationDBMeta = localEntity.getDBMeta();
    }

    public <SOURCE> void registerSourceList(List<SOURCE> sourceList) {
        this.sourceIterator = this.createDefaultSourceIterator(sourceList);
    }

    public void mapping(HierarchySourceColumn sourceColumn, DBMeta.RelationTrace relationTrace) {
        this.setupElement(sourceColumn, relationTrace.getTraceColumn());
        this.addRelationToLastElement(relationTrace.getTraceRelation());
    }

    public void mapping(ColumnInfo sourceColumnInfo, DBMeta.RelationTrace relationTrace) {
        this.setupElement(sourceColumnInfo, relationTrace.getTraceColumn());
        this.addRelationToLastElement(relationTrace.getTraceRelation());
    }

    protected void setupElement(HierarchySourceColumn sourceColumn, ColumnInfo destinationColumnInfo) {
        this.assertSameLocalDestinationDBMeta(destinationColumnInfo);
        HierarchyRequestElement element = new HierarchyRequestElement();
        this.requestElementList.add(element);
        element.mapping(sourceColumn, destinationColumnInfo);
        element.setDestinationDBMeta(destinationColumnInfo.getDBMeta());
    }

    protected void setupElement(ColumnInfo sourceColumnInfo, ColumnInfo destinationColumnInfo) {
        if (this.alreadyRegisteredSourceColumnInfoSet4Check.contains(sourceColumnInfo)) {
            String msg = "The wrong sourceColumnInfo!" + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "The source column has already been registered:" + this.getLineSeparator();
            msg = msg + "- - - - -" + this.getLineSeparator();
            msg = msg + " sourceColumnInfo=" + sourceColumnInfo + this.getLineSeparator();
            msg = msg + " registeredColumnInfo=" + this.alreadyRegisteredSourceColumnInfoSet4Check + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
        this.alreadyRegisteredSourceColumnInfoSet4Check.add(sourceColumnInfo);
        this.assertSameSourceDBMeta(sourceColumnInfo);
        this.assertSameLocalDestinationDBMeta(destinationColumnInfo);
        HierarchyRequestElement element = new HierarchyRequestElement();
        this.requestElementList.add(element);
        HierarchySourceColumn sourceColumn = this.createDefaultSourceColumn(sourceColumnInfo);
        element.mapping(sourceColumn, destinationColumnInfo);
        element.setDestinationDBMeta(destinationColumnInfo.getDBMeta());
    }

    protected void addRelationToLastElement(List<RelationInfo> relationInfoList) {
        if (this.requestElementList.isEmpty()) {
            String msg = "You shuold invoke mapping() before invoking relation()!";
            throw new IllegalStateException(msg);
        }
        for (RelationInfo relationInfo : relationInfoList) {
            int lastIndex = this.requestElementList.size() - 1;
            HierarchyRequestElement element = this.requestElementList.get(lastIndex);
            element.relation(relationInfo);
        }
    }

    protected void assertSameSourceDBMeta(ColumnInfo sourceColumnInfo) {
        DBMeta actualDBMeta;
        if (this.firstSourceColumnInfo4Check == null) {
            this.firstSourceColumnInfo4Check = sourceColumnInfo;
            return;
        }
        DBMeta expectedDBMeta = this.firstSourceColumnInfo4Check.getDBMeta();
        if (!expectedDBMeta.equals(actualDBMeta = sourceColumnInfo.getDBMeta())) {
            String msg = "The wrong sourceColumnInfo!" + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "The dbmeta of sourceColumnInfo is difference from";
            msg = msg + " the one of Your First Source Column Info:" + this.getLineSeparator();
            msg = msg + "- - - - -" + this.getLineSeparator();
            msg = msg + "sourceColumnInfo=" + sourceColumnInfo + this.getLineSeparator();
            msg = msg + "firstSourceColumnInfo4Check=" + this.firstSourceColumnInfo4Check + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
    }

    protected void assertSameLocalDestinationDBMeta(ColumnInfo destinationColumnInfo) {
        DBMeta actualDBMeta;
        DBMeta expectedDBMeta;
        HierarchyRequestElement currentElement;
        List<RelationInfo> relationInfoList;
        if (!this.requestElementList.isEmpty() && (relationInfoList = (currentElement = this.currentElement()).getRelationInfoList()).isEmpty() && !(expectedDBMeta = this.destinationDBMeta).equals(actualDBMeta = this.currentElement().getDestinationDBMeta())) {
            String msg = "The wrong destinationColumnInfo!" + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "The dbmeta of destinationColumnInfo is difference from";
            msg = msg + " the one of Your Local Entity:" + this.getLineSeparator();
            msg = msg + "- - - - -" + this.getLineSeparator();
            msg = msg + "destinationColumnInfo=" + currentElement.getDestinationColumnInfo() + this.getLineSeparator();
            msg = msg + "localEntity=" + this.destinationDBMeta.getEntityTypeName() + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
    }

    protected <SOURCE> HierarchySourceIterator createDefaultSourceIterator(List<SOURCE> sourceList) {
        return new HierarchySourceEntityListIterator<SOURCE>(sourceList);
    }

    protected HierarchySourceColumn createDefaultSourceColumn(ColumnInfo sourceColumnInfo) {
        return new HierarchySourceEntityColumn(sourceColumnInfo);
    }

    protected HierarchyRequestElement currentElement() {
        int lastIndex = this.requestElementList.size() - 1;
        return this.requestElementList.get(lastIndex);
    }

    public List<HierarchyRequestElement> findPrimaryKeyElement(String relationPropertyKey) {
        ArrayList<HierarchyRequestElement> resultList = new ArrayList<HierarchyRequestElement>();
        for (HierarchyRequestElement element : this.requestElementList) {
            ColumnInfo destinationColumnInfo;
            if (!relationPropertyKey.equals(element.getRelationPropertyKey()) || !(destinationColumnInfo = element.getDestinationColumnInfo()).isPrimary()) continue;
            resultList.add(element);
        }
        if (resultList.isEmpty()) {
            String msg = "Not found primary key element by relationPropertyKey in requestElementList: ";
            msg = msg + " relationPropertyKey=" + relationPropertyKey + " requestElementList=" + this.requestElementList;
            throw new IllegalStateException(msg);
        }
        return resultList;
    }

    public DBMeta getDestinationDBMeta() {
        return this.destinationDBMeta;
    }

    public void setDestinationDBMeta(DBMeta destinationDBMeta) {
        this.destinationDBMeta = destinationDBMeta;
    }

    public List<HierarchyRequestElement> getRequestElementList() {
        return this.requestElementList;
    }

    public void addRequestElementList(HierarchyRequestElement element) {
        this.requestElementList.add(element);
    }

    public HierarchySourceIterator getSourceIterator() {
        return this.sourceIterator;
    }

    public void setSourceIterator(HierarchySourceIterator sourceIterator) {
        this.sourceIterator = sourceIterator;
    }

    protected String getLineSeparator() {
        return System.getProperty("line.separator");
    }
}

