/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSet
implements Set<String> {
    protected static final Object DUMMY_VALUE = new Object();
    protected final Map<String, Object> _internalMap;
    protected boolean _removeUnderscore;

    protected StringSet(boolean removeUnderscore, boolean order, boolean concurrent) {
        if (order && concurrent) {
            String msg = "The 'order' and 'concurrent' should not be both true at the same time!";
            throw new IllegalStateException(msg);
        }
        this._removeUnderscore = removeUnderscore;
        this._internalMap = concurrent ? StringSet.newConcurrentHashMap() : (order ? StringSet.newLinkedHashMap() : StringSet.newHashMap());
    }

    public static StringSet createAsCaseInsensitive() {
        return new StringSet(false, false, false);
    }

    public static StringSet createAsCaseInsensitiveConcurrent() {
        return new StringSet(false, false, true);
    }

    public static StringSet createAsCaseInsensitiveOrder() {
        return new StringSet(false, true, false);
    }

    public static StringSet createAsFlexible() {
        return new StringSet(true, false, false);
    }

    public static StringSet createAsFlexibleConcurrent() {
        return new StringSet(true, false, true);
    }

    public static StringSet createAsFlexibleOrder() {
        return new StringSet(true, true, false);
    }

    @Override
    public boolean add(String value) {
        String stringValue = this.convertStringKey(value);
        if (stringValue != null) {
            return this._internalMap.put(stringValue, DUMMY_VALUE) != null;
        }
        return false;
    }

    @Override
    public boolean remove(Object value) {
        String stringValue = this.convertStringKey(value);
        if (stringValue != null) {
            return this._internalMap.remove(stringValue) != null;
        }
        return false;
    }

    @Override
    public boolean contains(Object value) {
        String stringValue = this.convertStringKey(value);
        if (stringValue != null) {
            return this._internalMap.containsKey(stringValue);
        }
        return false;
    }

    @Override
    public void clear() {
        this._internalMap.clear();
    }

    @Override
    public int size() {
        return this._internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._internalMap.isEmpty();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean success = false;
        for (String string : c) {
            if (!this.add(string)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean success = false;
        for (Object s : c) {
            if (!this.remove(s)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object s : c) {
            if (!this.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this._internalMap.keySet().iterator();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean success = false;
        for (Object s : c) {
            if (this.contains(s) || !this.remove(s)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public Object[] toArray() {
        return this._internalMap.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._internalMap.keySet().toArray(a);
    }

    protected String convertStringKey(Object value) {
        if (!(value instanceof String)) {
            return null;
        }
        return this.toLowerCase(this.removeUnderscore((String)value));
    }

    protected String removeUnderscore(String value) {
        if (this._removeUnderscore) {
            return StringSet.replace(value, "_", "");
        }
        return value;
    }

    protected String toLowerCase(String value) {
        return value.toLowerCase();
    }

    protected static String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                sb.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(toText);
            pos2 = pos + fromText.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    protected static <KEY, VALUE> ConcurrentHashMap<KEY, VALUE> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    protected static <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this._internalMap.keySet()).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this._internalMap.keySet()).hashCode();
    }

    public String toString() {
        return this._internalMap.keySet().toString();
    }
}

