/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.registered;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.dbflute.util.DfTypeUtil;

public class BinaryType
extends TnAbstractValueType {
    public BinaryType() {
        super(-2);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        try {
            return this.toByteArray(resultSet.getBlob(index));
        }
        catch (SQLException e) {
            return resultSet.getBytes(index);
        }
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        try {
            return this.toByteArray(resultSet.getBlob(columnName));
        }
        catch (SQLException e) {
            return resultSet.getBytes(columnName);
        }
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        try {
            return this.toByteArray(cs.getBlob(index));
        }
        catch (SQLException e) {
            return cs.getBytes(index);
        }
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        try {
            return this.toByteArray(cs.getBlob(parameterName));
        }
        catch (SQLException e) {
            return cs.getBytes(parameterName);
        }
    }

    private byte[] toByteArray(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        long l = blob.length();
        if (Integer.MAX_VALUE < l) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return blob.getBytes(1L, (int)l);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            ByteArrayInputStream in = new ByteArrayInputStream(ba);
            ps.setBinaryStream(index, (InputStream)in, ba.length);
        } else {
            ps.setObject(index, value);
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            ByteArrayInputStream in = new ByteArrayInputStream(ba);
            cs.setBinaryStream(parameterName, (InputStream)in, ba.length);
        } else {
            cs.setObject(parameterName, value);
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return DfTypeUtil.nullText();
        }
        if (value instanceof byte[]) {
            return DfTypeUtil.toText((byte[])value);
        }
        return DfTypeUtil.toText(value);
    }
}

