/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfStringUtil {
    protected static final String[] EMPTY_STRINGS = new String[0];

    public static final boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static final boolean isNotEmpty(String text) {
        return !DfStringUtil.isEmpty(text);
    }

    public static String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                sb.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(text.substring(pos2, pos));
            sb.append(toText);
            pos2 = pos + fromText.length();
        }
        sb.append(text.substring(pos2));
        return sb.toString();
    }

    public static String[] split(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String rtrim(String text) {
        return DfStringUtil.rtrim(text, null);
    }

    public static final String rtrim(String text, String trimText) {
        int pos;
        if (text == null) {
            return null;
        }
        if (trimText == null) {
            trimText = " ";
        }
        for (pos = text.length() - 1; pos >= 0 && trimText.indexOf(text.charAt(pos)) >= 0; --pos) {
        }
        return text.substring(0, pos + 1);
    }

    public static String initCap(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String initCapAfterTrimming(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        return DfStringUtil.initCap(str);
    }

    public static String initUncap(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String decamelizePropertyName(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        StringBuilder sb = new StringBuilder(40);
        int pos = 0;
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            if (sb.length() != 0) {
                sb.append('_');
            }
            sb.append(s.substring(pos, i).toUpperCase());
            pos = i;
        }
        if (sb.length() != 0) {
            sb.append('_');
        }
        sb.append(s.substring(pos, s.length()).toUpperCase());
        return sb.toString();
    }

    public static String decapitalizePropertyName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return propertyName;
        }
        if (propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1)) && Character.isUpperCase(propertyName.charAt(0))) {
            return propertyName;
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String extractFirstScope(String targetStr, String beginMark, String endMark) {
        if (targetStr == null || beginMark == null || endMark == null) {
            return null;
        }
        String tmp = targetStr;
        int startIndex = tmp.indexOf(beginMark);
        if (startIndex < 0) {
            return null;
        }
        if ((tmp = tmp.substring(startIndex + beginMark.length())).indexOf(endMark) < 0) {
            return null;
        }
        String ret = tmp.substring(0, tmp.indexOf(endMark)).trim();
        return ret;
    }

    public static List<String> extractAllScope(String targetStr, String beginMark, String endMark) {
        int startIndex;
        if (targetStr == null || beginMark == null || endMark == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String tmp = targetStr;
        while ((startIndex = tmp.indexOf(beginMark)) >= 0 && (tmp = tmp.substring(startIndex + beginMark.length())).indexOf(endMark) >= 0) {
            resultList.add(tmp.substring(0, tmp.indexOf(endMark)).trim());
            tmp = tmp.substring(tmp.indexOf(endMark) + endMark.length());
        }
        return resultList;
    }

    public static boolean containsIgnoreCase(String target, List<String> strList) {
        if (target == null || strList == null) {
            return false;
        }
        for (String str : strList) {
            if (!target.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }
}

