/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSetBase;

public class DocSlice
extends DocSetBase
implements DocList {
    final int offset;
    final int len;
    final int[] docs;
    final float[] scores;
    final int matches;
    final float maxScore;

    public DocSlice(int offset, int len, int[] docs, float[] scores, int matches, float maxScore) {
        this.offset = offset;
        this.len = len;
        this.docs = docs;
        this.scores = scores;
        this.matches = matches;
        this.maxScore = maxScore;
    }

    public DocList subset(int offset, int len) {
        if (this.offset == offset && this.len == len) {
            return this;
        }
        int requestedEnd = offset + len;
        if (requestedEnd > this.docs.length && this.matches > this.docs.length) {
            return null;
        }
        int realEndDoc = Math.min(requestedEnd, this.docs.length);
        int realLen = Math.max(realEndDoc - offset, 0);
        if (this.offset == offset && this.len == realLen) {
            return this;
        }
        return new DocSlice(offset, realLen, this.docs, this.scores, this.matches, this.maxScore);
    }

    public boolean hasScores() {
        return this.scores != null;
    }

    public float maxScore() {
        return this.maxScore;
    }

    public int offset() {
        return this.offset;
    }

    public int size() {
        return this.len;
    }

    public int matches() {
        return this.matches;
    }

    public long memSize() {
        return (this.docs.length << 2) + (this.scores == null ? 0 : this.scores.length << 2) + 24;
    }

    public boolean exists(int doc) {
        for (int i : this.docs) {
            if (i != doc) continue;
            return true;
        }
        return false;
    }

    public DocIterator iterator() {
        return new DocIterator(){
            int pos;
            final int end;
            {
                this.pos = DocSlice.this.offset;
                this.end = DocSlice.this.offset + DocSlice.this.len;
            }

            public boolean hasNext() {
                return this.pos < this.end;
            }

            public Integer next() {
                return this.nextDoc();
            }

            public void remove() {
                throw new UnsupportedOperationException("The remove  operation is not supported by this Iterator.");
            }

            public int nextDoc() {
                return DocSlice.this.docs[this.pos++];
            }

            public float score() {
                return DocSlice.this.scores[this.pos - 1];
            }
        };
    }
}

