/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrIndexConfig;

public class SolrIndexWriter
extends IndexWriter {
    private static Logger log = Logger.getLogger(SolrIndexWriter.class.getName());
    String name;
    IndexSchema schema;

    private void init(String name, IndexSchema schema, SolrIndexConfig config) throws IOException {
        log.fine("Opened Writer " + name);
        this.name = name;
        this.schema = schema;
        this.setSimilarity(schema.getSimilarity());
        if (config != null) {
            this.setUseCompoundFile(config.useCompoundFile);
            if (config.maxBufferedDocs != -1) {
                this.setMaxBufferedDocs(config.maxBufferedDocs);
            }
            if (config.ramBufferSizeMB != -1.0) {
                this.setRAMBufferSizeMB(config.ramBufferSizeMB);
            }
            if (config.maxMergeDocs != -1) {
                this.setMaxMergeDocs(config.maxMergeDocs);
            }
            if (config.maxFieldLength != -1) {
                this.setMaxFieldLength(config.maxFieldLength);
            }
            if (config.mergePolicyClassName != null && !SolrIndexConfig.DEFAULT_MERGE_POLICY_CLASSNAME.equals(config.mergePolicyClassName)) {
                MergePolicy policy = (MergePolicy)schema.getSolrConfig().getResourceLoader().newInstance(config.mergePolicyClassName, new String[0]);
                this.setMergePolicy(policy);
            }
            if (config.mergeFactor != -1 && this.getMergePolicy() instanceof LogMergePolicy) {
                this.setMergeFactor(config.mergeFactor);
            }
            if (config.mergeSchedulerClassname != null && !SolrIndexConfig.DEFAULT_MERGE_SCHEDULER_CLASSNAME.equals(config.mergeSchedulerClassname)) {
                MergeScheduler scheduler = (MergeScheduler)schema.getSolrConfig().getResourceLoader().newInstance(config.mergeSchedulerClassname, new String[0]);
                this.setMergeScheduler(scheduler);
            }
        }
    }

    public static Directory getDirectory(String path, SolrIndexConfig config) throws IOException {
        String lockType;
        String rawLockType;
        FSDirectory d = FSDirectory.getDirectory((String)path);
        String string = rawLockType = null == config ? null : config.lockType;
        if (null == rawLockType) {
            log.warning("No lockType configured for " + path + " assuming 'simple'");
            rawLockType = "simple";
        }
        if ("simple".equals(lockType = rawLockType.toLowerCase().trim())) {
            d.setLockFactory((LockFactory)new SimpleFSLockFactory(path));
        } else if ("native".equals(lockType)) {
            d.setLockFactory((LockFactory)new NativeFSLockFactory(path));
        } else if ("single".equals(lockType)) {
            if (!(d.getLockFactory() instanceof SingleInstanceLockFactory)) {
                d.setLockFactory((LockFactory)new SingleInstanceLockFactory());
            }
        } else if ("none".equals(lockType)) {
            log.severe("CONFIGURATION WARNING: locks are disabled on " + path);
            d.setLockFactory((LockFactory)new NoLockFactory());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
        }
        return d;
    }

    public SolrIndexWriter(String name, String path, boolean create, IndexSchema schema) throws IOException {
        super(SolrIndexWriter.getDirectory(path, null), false, schema.getAnalyzer(), create);
        this.init(name, schema, null);
    }

    public SolrIndexWriter(String name, String path, boolean create, IndexSchema schema, SolrIndexConfig config) throws IOException {
        super(SolrIndexWriter.getDirectory(path, config), config.luceneAutoCommit, schema.getAnalyzer(), create);
        this.init(name, schema, config);
    }

    public void close() throws IOException {
        log.fine("Closing Writer " + this.name);
        super.close();
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

