/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.HitCollector;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrIndexWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class UpdateHandler
implements SolrInfoMBean {
    protected static final Logger log = Logger.getLogger(UpdateHandler.class.getName());
    protected final SolrCore core;
    protected final IndexSchema schema;
    protected final SchemaField idField;
    protected final FieldType idFieldType;
    protected final Term idTerm;
    protected Vector<SolrEventListener> commitCallbacks = new Vector();
    protected Vector<SolrEventListener> optimizeCallbacks = new Vector();

    private void parseEventListeners() {
        SolrEventListener listener;
        String className;
        Node node;
        int i;
        SolrConfig solrConfig = this.core.getSolrConfig();
        NodeList nodes = (NodeList)solrConfig.evaluate("updateHandler/listener[@event=\"postCommit\"]", XPathConstants.NODESET);
        if (nodes != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                try {
                    className = DOMUtil.getAttr((Node)node, (String)"class");
                    listener = this.core.createEventListener(className);
                    listener.init(DOMUtil.childNodesToNamedList((Node)node));
                    this.commitCallbacks.add(listener);
                    log.info("added SolrEventListener for postCommit: " + listener);
                    continue;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error parsing event listevers", (Throwable)e, false);
                }
            }
        }
        if ((nodes = (NodeList)solrConfig.evaluate("updateHandler/listener[@event=\"postOptimize\"]", XPathConstants.NODESET)) != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                try {
                    className = DOMUtil.getAttr((Node)node, (String)"class");
                    listener = this.core.createEventListener(className);
                    listener.init(DOMUtil.childNodesToNamedList((Node)node));
                    this.optimizeCallbacks.add(listener);
                    log.info("added SolarEventListener for postOptimize: " + listener);
                    continue;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error parsing event listeners", (Throwable)e, false);
                }
            }
        }
    }

    protected void callPostCommitCallbacks() {
        for (SolrEventListener listener : this.commitCallbacks) {
            listener.postCommit();
        }
    }

    protected void callPostOptimizeCallbacks() {
        for (SolrEventListener listener : this.optimizeCallbacks) {
            listener.postCommit();
        }
    }

    public UpdateHandler(SolrCore core) {
        this.core = core;
        this.schema = core.getSchema();
        this.idField = this.schema.getUniqueKeyField();
        this.idFieldType = this.idField != null ? this.idField.getType() : null;
        this.idTerm = this.idField != null ? new Term(this.idField.getName(), "") : null;
        this.parseEventListeners();
    }

    protected SolrIndexWriter createMainIndexWriter(String name, boolean removeAllExisting) throws IOException {
        return new SolrIndexWriter(name, this.core.getIndexDir(), removeAllExisting, this.schema, this.core.getSolrConfig().mainIndexConfig);
    }

    protected final Term idTerm(String readableId) {
        return new Term(this.idField.getName(), this.idFieldType.toInternal(readableId));
    }

    protected final String getIndexedId(Document doc) {
        if (this.idField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Operation requires schema to have a unique key field");
        }
        Fieldable[] id = doc.getFieldables(this.idField.getName());
        if (id == null || id.length < 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document is missing uniqueKey field " + this.idField.getName());
        }
        if (id.length > 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document specifies multiple unique ids! " + this.idField.getName());
        }
        return this.idFieldType.storedToIndexed(id[0]);
    }

    protected final String getIndexedIdOptional(Document doc) {
        if (this.idField == null) {
            return null;
        }
        Field f = doc.getField(this.idField.getName());
        if (f == null) {
            return null;
        }
        return this.idFieldType.storedToIndexed((Fieldable)f);
    }

    public abstract int addDoc(AddUpdateCommand var1) throws IOException;

    public abstract void delete(DeleteUpdateCommand var1) throws IOException;

    public abstract void deleteByQuery(DeleteUpdateCommand var1) throws IOException;

    public abstract void commit(CommitUpdateCommand var1) throws IOException;

    public abstract void close() throws IOException;

    public void registerCommitCallback(SolrEventListener listener) {
        this.commitCallbacks.add(listener);
    }

    public void registerOptimizeCallback(SolrEventListener listener) {
        this.optimizeCallbacks.add(listener);
    }

    class DeleteHitCollector
    extends HitCollector {
        public int deleted = 0;
        public final SolrIndexSearcher searcher;

        public DeleteHitCollector(SolrIndexSearcher searcher) {
            this.searcher = searcher;
        }

        public void collect(int doc, float score) {
            try {
                this.searcher.getReader().deleteDocument(doc);
                ++this.deleted;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error deleting doc# " + doc, (Throwable)e, false);
            }
        }
    }
}

