/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import org.apache.tika.language.NGramProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NGramEntry
implements Comparable<NGramEntry> {
    private final NGramProfile profile;
    private CharSequence seq = null;
    private int count = 0;
    private float frequency = 0.0f;

    public NGramEntry(NGramProfile nGramProfile, CharSequence seq) {
        this.profile = nGramProfile;
        this.seq = seq;
    }

    public NGramEntry(NGramProfile nGramProfile, String seq, int count) {
        this.profile = nGramProfile;
        this.seq = new StringBuffer(seq).subSequence(0, seq.length());
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public void calculateFrequency(int totalCount) {
        this.frequency = (float)this.count / (float)totalCount;
    }

    public CharSequence getSeq() {
        return this.seq;
    }

    public int size() {
        return this.seq.length();
    }

    @Override
    public int compareTo(NGramEntry ngram) {
        int diff = Float.compare(ngram.getFrequency(), this.frequency);
        if (diff != 0) {
            return diff;
        }
        return this.toString().compareTo(ngram.toString());
    }

    public void inc() {
        ++this.count;
    }

    public NGramProfile getProfile() {
        return this.profile;
    }

    public String toString() {
        return "ngram(" + this.seq + "," + this.count + "," + this.frequency + ")";
    }

    public int hashCode() {
        return this.seq.hashCode();
    }

    public boolean equals(Object obj) {
        NGramEntry ngram = null;
        try {
            ngram = (NGramEntry)obj;
            return ngram.seq.equals(this.seq);
        }
        catch (Exception e) {
            return false;
        }
    }
}

