/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SafeContentHandler
extends ContentHandlerDecorator {
    private static final char[] REPLACEMENT = new char[]{' '};
    private final Output charactersOutput = new Output(){

        public void write(char[] ch, int start, int length) throws SAXException {
            SafeContentHandler.super.characters(ch, start, length);
        }
    };
    private final Output ignorableWhitespaceOutput = new Output(){

        public void write(char[] ch, int start, int length) throws SAXException {
            SafeContentHandler.super.ignorableWhitespace(ch, start, length);
        }
    };

    public SafeContentHandler(ContentHandler handler) {
        super(handler);
    }

    private void filter(char[] ch, int start, int length, Output output) throws SAXException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            if (!this.isInvalid(ch[i])) continue;
            if (i > start) {
                output.write(ch, start, i - start);
            }
            this.writeReplacement(output);
            start = i + 1;
        }
        output.write(ch, start, end - start);
    }

    protected boolean isInvalid(char ch) {
        if (ch < ' ') {
            return ch != '\t' && ch != '\n' && ch != '\r';
        }
        return ch >= '\ufffe';
    }

    protected void writeReplacement(Output output) throws SAXException {
        output.write(REPLACEMENT, 0, REPLACEMENT.length);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.filter(ch, start, length, this.charactersOutput);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.filter(ch, start, length, this.ignorableWhitespaceOutput);
    }

    protected static interface Output {
        public void write(char[] var1, int var2, int var3) throws SAXException;
    }
}

