/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.EvaluatorBag;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConfig {
    public List<Document> documents;
    public List<Props> properties;
    private Map<String, Document> documentCache;
    public Map<String, Evaluator> evaluators = new HashMap<String, Evaluator>();
    public Script script;
    public Map<String, Properties> dataSources = new HashMap<String, Properties>();
    public static final String SCRIPT = "script";
    public static final String NAME = "name";
    public static final String SCRIPT_LANG = "scriptlanguage";
    public static final String SCRIPT_NAME = "scriptname";
    public static final String PROCESSOR = "processor";
    public static final String IMPORTER_NS = "dataimporter";
    public static final String ROOT_ENTITY = "rootEntity";
    public static final String FUNCTION = "function";
    public static final String CLASS = "class";
    public static final String DATA_SRC = "dataSource";

    public Document getDocumentByName(String name) {
        if (this.documentCache == null) {
            this.documentCache = new HashMap<String, Document>();
            for (Document document : this.documents) {
                this.documentCache.put(document.name, document);
            }
        }
        return this.documentCache.get(name);
    }

    public void readFromXml(Element e) {
        List<Element> n = DataConfig.getChildNodes(e, "document");
        if (!n.isEmpty()) {
            this.documents = new ArrayList<Document>();
        }
        for (Element element : n) {
            this.documents.add(new Document(element));
        }
        n = DataConfig.getChildNodes(e, SCRIPT);
        if (!n.isEmpty()) {
            this.script = new Script(n.get(0));
        }
        this.evaluators.put("formatDate", EvaluatorBag.getDateFormatEvaluator());
        this.evaluators.put("escapeSql", EvaluatorBag.getSqlEscapingEvaluator());
        this.evaluators.put("encodeUrl", EvaluatorBag.getUrlEvaluator());
        n = DataConfig.getChildNodes(e, FUNCTION);
        if (!n.isEmpty()) {
            for (Element element : n) {
                String func = DataConfig.getStringAttribute(element, NAME, null);
                String clz = DataConfig.getStringAttribute(element, CLASS, null);
                if (func == null || clz == null) {
                    throw new DataImportHandlerException(500, "<function> must have a 'name' and 'class' attributes");
                }
                try {
                    this.evaluators.put(func, (Evaluator)DocBuilder.loadClass(clz, null).newInstance());
                }
                catch (Exception exp) {
                    throw new DataImportHandlerException(500, "Unable to instantiate evaluator: " + clz, exp);
                }
            }
        }
        if (!(n = DataConfig.getChildNodes(e, DATA_SRC)).isEmpty()) {
            for (Element element : n) {
                Properties p = new Properties();
                HashMap<String, String> attrs = DataConfig.getAllAttributes(element);
                for (Map.Entry<String, String> entry : attrs.entrySet()) {
                    p.setProperty(entry.getKey(), entry.getValue());
                }
                this.dataSources.put(p.getProperty(NAME), p);
            }
        }
    }

    private static String getStringAttribute(Element e, String name, String def) {
        String r = e.getAttribute(name);
        if (r == null || "".equals(r.trim())) {
            r = def;
        }
        return r;
    }

    private static HashMap<String, String> getAllAttributes(Element e) {
        HashMap<String, String> m = new HashMap<String, String>();
        NamedNodeMap nnm = e.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            m.put(nnm.item(i).getNodeName(), nnm.item(i).getNodeValue());
        }
        return m;
    }

    public static String getTxt(Node elem, StringBuffer buffer) {
        if (elem.getNodeType() != 4) {
            NodeList childs = elem.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                short childType = child.getNodeType();
                if (childType == 8 || childType == 7) continue;
                DataConfig.getTxt(child, buffer);
            }
        } else {
            buffer.append(elem.getNodeValue());
        }
        return buffer.toString();
    }

    public static List<Element> getChildNodes(Element e, String byName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList l = e.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (!e.equals(l.item(i).getParentNode()) || !byName.equals(l.item(i).getNodeName())) continue;
            result.add((Element)l.item(i));
        }
        return result;
    }

    public void clearCaches() {
        for (Document document : this.documents) {
            for (Entity entity : document.entities) {
                entity.clearCache();
            }
        }
    }

    public static class Field {
        public String column;
        public String name;
        public Float boost = Float.valueOf(1.0f);
        public boolean toWrite = true;
        public boolean multiValued = false;
        public String nameOrColName;
        public Map<String, String> allAttributes = new HashMap<String, String>(){

            @Override
            public String put(String key, String value) {
                if (super.containsKey(key)) {
                    return (String)super.get(key);
                }
                return super.put(key, value);
            }
        };
        public Entity entity;

        public Field() {
        }

        public Field(Element e) {
            this.name = DataConfig.getStringAttribute(e, DataConfig.NAME, null);
            this.column = DataConfig.getStringAttribute(e, "column", null);
            this.boost = Float.valueOf(Float.parseFloat(DataConfig.getStringAttribute(e, "boost", "1.0f")));
            this.allAttributes.putAll(DataConfig.getAllAttributes(e));
        }

        public Field(String name, boolean b) {
            this.nameOrColName = this.column = name;
            name = this.column;
            this.multiValued = b;
        }

        public String getName() {
            return this.name == null ? this.column : this.name;
        }
    }

    public static class Script {
        public String language;
        public String script;

        public Script() {
        }

        public Script(Element e) {
            this.language = DataConfig.getStringAttribute(e, "language", "JavaScript");
            StringBuffer buffer = new StringBuffer();
            String script = DataConfig.getTxt(e, buffer);
            if (script != null) {
                this.script = script.trim();
            }
        }
    }

    public static class Entity {
        public String name;
        public String pk;
        public String dataSource;
        public Map<String, String> allAttributes;
        public String proc;
        public String docRoot;
        public boolean isDocRoot = false;
        public List<Field> fields;
        public List<Map<String, String>> allFieldsList = new ArrayList<Map<String, String>>();
        public List<Entity> entities;
        public String[] primaryKeys;
        public Entity parentEntity;
        public EntityProcessor processor;
        public DataSource dataSrc;
        public Script script;
        public List<Field> implicitFields;

        public Entity() {
        }

        public Entity(Element element) {
            this.name = DataConfig.getStringAttribute(element, DataConfig.NAME, null);
            this.pk = DataConfig.getStringAttribute(element, "pk", null);
            this.docRoot = DataConfig.getStringAttribute(element, DataConfig.ROOT_ENTITY, null);
            this.proc = DataConfig.getStringAttribute(element, DataConfig.PROCESSOR, null);
            this.dataSource = DataConfig.getStringAttribute(element, DataConfig.DATA_SRC, null);
            this.allAttributes = DataConfig.getAllAttributes(element);
            List<Element> n = DataConfig.getChildNodes(element, "field");
            this.fields = new ArrayList<Field>();
            for (Element elem : n) {
                this.fields.add(new Field(elem));
            }
            n = DataConfig.getChildNodes(element, "entity");
            if (!n.isEmpty()) {
                this.entities = new ArrayList<Entity>();
            }
            for (Element elem : n) {
                this.entities.add(new Entity(elem));
            }
        }

        public void clearCache() {
            if (this.entities != null) {
                for (Entity entity : this.entities) {
                    entity.clearCache();
                }
            }
            try {
                this.processor.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processor = null;
            if (this.dataSrc != null) {
                this.dataSrc.close();
            }
        }
    }

    public static class Props {
        public String name;
        public String file;
    }

    public static class Document {
        public String name;
        public String deleteQuery;
        public List<Entity> entities = new ArrayList<Entity>();
        public List<Field> fields;

        public Document() {
        }

        public Document(Element element) {
            this.name = DataConfig.getStringAttribute(element, DataConfig.NAME, null);
            this.deleteQuery = DataConfig.getStringAttribute(element, "deleteQuery", null);
            List<Element> l = DataConfig.getChildNodes(element, "entity");
            for (Element e : l) {
                this.entities.add(new Entity(e));
            }
            l = DataConfig.getChildNodes(element, "field");
            if (!l.isEmpty()) {
                this.fields = new ArrayList<Field>();
            }
            for (Element e : l) {
                this.fields.add(new Field(e));
            }
        }
    }
}

