/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexTransformer
extends Transformer {
    private static final Logger LOG = Logger.getLogger(RegexTransformer.class.getName());
    private HashMap<String, Pattern> PATTERN_CACHE = new HashMap();
    public static final String REGEX = "regex";
    public static final String REPLACE_WITH = "replaceWith";
    public static final String SPLIT_BY = "splitBy";
    public static final String SRC_COL_NAME = "sourceColName";

    @Override
    public Map<String, Object> transformRow(Map<String, Object> row, Context context) {
        List<Map<String, String>> fields = context.getAllEntityFields();
        for (Map<String, String> field : fields) {
            Object tmpVal;
            String col = field.get("column");
            String reStr = field.get(REGEX);
            String splitBy = field.get(SPLIT_BY);
            String replaceWith = field.get(REPLACE_WITH);
            if (reStr == null && splitBy == null) continue;
            String srcColName = field.get(SRC_COL_NAME);
            if (srcColName == null) {
                srcColName = col;
            }
            if ((tmpVal = row.get(srcColName)) == null) continue;
            if (tmpVal instanceof List) {
                List inputs = (List)tmpVal;
                ArrayList<Object> results = new ArrayList<Object>();
                for (String input : inputs) {
                    Object o = this.process(col, reStr, splitBy, replaceWith, input);
                    if (o == null) continue;
                    results.add(o);
                }
                row.put(col, results);
                continue;
            }
            String value = tmpVal.toString();
            Object o = this.process(col, reStr, splitBy, replaceWith, value);
            if (o == null) continue;
            row.put(col, o);
        }
        return row;
    }

    private Object process(String col, String reStr, String splitBy, String replaceWith, String value) {
        if (splitBy != null) {
            return this.readBySplit(splitBy, value);
        }
        if (replaceWith != null) {
            Pattern p = this.getPattern(reStr);
            return p.matcher(value).replaceAll(replaceWith);
        }
        return this.readfromRegExp(reStr, value, col);
    }

    private List<String> readBySplit(String splitBy, String value) {
        String[] vals = value.split(splitBy);
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(Arrays.asList(vals));
        return l;
    }

    private Object readfromRegExp(String reStr, String value, String columnName) {
        Pattern regexp = this.getPattern(reStr);
        Matcher m = regexp.matcher(value);
        if (m.find() && m.groupCount() > 0) {
            if (m.groupCount() > 1) {
                ArrayList<String> l = new ArrayList<String>();
                for (int i = 1; i <= m.groupCount(); ++i) {
                    try {
                        l.add(m.group(i));
                        continue;
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Parsing failed for field : " + columnName, e);
                    }
                }
                return l;
            }
            return m.group(1);
        }
        return null;
    }

    private Pattern getPattern(String reStr) {
        Pattern result = this.PATTERN_CACHE.get(reStr);
        if (result == null) {
            result = Pattern.compile(reStr);
            this.PATTERN_CACHE.put(reStr, result);
        }
        return result;
    }
}

