/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.ckey;

import java.util.List;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.cvalue.ConditionValue;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClause;
import org.seasar.dbflute.dbmeta.name.ColumnRealName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionKeyLessEqual
extends ConditionKey {
    private static final long serialVersionUID = 1L;

    protected ConditionKeyLessEqual() {
        this.initializeConditionKey();
        this.initializeOperand();
    }

    protected void initializeConditionKey() {
        this._conditionKey = "lessEqual";
    }

    protected void initializeOperand() {
        this._operand = "<=";
    }

    @Override
    protected boolean doIsValidRegistration(ConditionValue cvalue, Object value, ColumnRealName callerName) {
        if (value == null) {
            return false;
        }
        if (cvalue.isFixedQuery() && cvalue.hasLessEqual()) {
            if (cvalue.equalLessEqual(value)) {
                this.noticeRegistered(callerName, value);
                return false;
            }
            cvalue.overrideLessEqual(value);
            return false;
        }
        return true;
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ColumnFunctionCipher cipher) {
        conditionList.add(this.buildBindClause(columnRealName, value.getLessEqualLatestLocation(), cipher));
    }

    @Override
    protected void doAddWhereClause(List<QueryClause> conditionList, ColumnRealName columnRealName, ConditionValue value, ColumnFunctionCipher cipher, ConditionOption option) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location) {
        conditionValue.setupLessEqual(value, location);
    }

    @Override
    protected void doSetupConditionValue(ConditionValue conditionValue, Object value, String location, ConditionOption option) {
        throw new UnsupportedOperationException();
    }
}

