/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.twowaysql.node;

import java.lang.reflect.Array;
import java.util.Collection;
import org.seasar.dbflute.twowaysql.context.CommandContext;
import org.seasar.dbflute.twowaysql.node.LoopInfo;
import org.seasar.dbflute.twowaysql.node.ValueAndType;
import org.seasar.dbflute.twowaysql.node.ValueAndTypeSetupper;
import org.seasar.dbflute.twowaysql.node.VariableNode;

public class BindVariableNode
extends VariableNode {
    public BindVariableNode(String expression, String testValue, String specifiedSql, boolean blockNullParameter) {
        super(expression, testValue, specifiedSql, blockNullParameter);
    }

    protected void doProcess(CommandContext ctx, ValueAndType valueAndType, LoopInfo loopInfo) {
        Object finalValue = valueAndType.getTargetValue();
        Class<?> finalType = valueAndType.getTargetType();
        if (this.isInScope()) {
            if (finalValue == null) {
                this.throwBindOrEmbeddedCommentParameterNullValueException(valueAndType);
            }
            if (Collection.class.isAssignableFrom(finalType)) {
                this.bindArray(ctx, ((Collection)finalValue).toArray());
            } else if (finalType.isArray()) {
                this.bindArray(ctx, finalValue);
            } else {
                this.throwBindOrEmbeddedCommentInScopeNotListException(valueAndType);
            }
        } else {
            ctx.addSql("?", finalValue, finalType);
            if (this.isAcceptableLikeSearch(loopInfo)) {
                this.setupRearOption(ctx, valueAndType);
            }
        }
    }

    protected void bindArray(CommandContext ctx, Object array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        if (length == 0) {
            this.throwBindOrEmbeddedCommentParameterEmptyListException();
        }
        Class<?> clazz = null;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            clazz = currentElement.getClass();
            break;
        }
        if (clazz == null) {
            this.throwBindOrEmbeddedCommentParameterNullOnlyListException();
        }
        ctx.addSql("(");
        int validCount = 0;
        for (int i = 0; i < length; ++i) {
            Object currentElement = Array.get(array, i);
            if (currentElement == null) continue;
            if (validCount > 0) {
                ctx.addSql(", ");
            }
            ctx.addSql("?", currentElement, clazz);
            ++validCount;
        }
        ctx.addSql(")");
    }

    protected ValueAndTypeSetupper.CommentType getCommentType() {
        return ValueAndTypeSetupper.CommentType.BIND;
    }
}

