/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.analytics;

import java.nio.charset.Charset;
import org.mobylet.core.Carrier;
import org.mobylet.core.Mobylet;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.device.DeviceDisplay;

public class AnalyticsParameters {
    protected Charset requestCharset;
    protected String urchinId;
    protected String visitorId;
    protected String userAgent;
    protected Carrier carrier;
    protected String domain;
    protected String referer;
    protected String uri;
    protected String utmn;
    protected String random;
    protected String today;
    protected String displaySize;
    protected String processor;
    protected String useLanguage;

    public AnalyticsParameters(String urchinId) {
        this.urchinId = urchinId;
        this.processor = "32-bit";
        this.useLanguage = "ja";
        this.utmn = "" + (long)(1.0E9 + Math.random() * 8.999999999E9);
        this.random = "" + (long)(1.0E9 + Math.random() * 1.147483647E9);
        this.today = "" + System.currentTimeMillis() / 1000L;
        Mobylet m = MobyletFactory.getInstance();
        DeviceDisplay display = m.getDisplay();
        this.displaySize = display != null ? display.getWidth() + "x" + display.getHeight() : "1280x960";
        this.requestCharset = m.getDialect().getCharset();
        this.carrier = m.getCarrier();
    }

    public String getUtmn() {
        return this.utmn;
    }

    public String getRandom() {
        return this.random;
    }

    public String getToday() {
        return this.today;
    }

    public String getDisplaySize() {
        return this.displaySize;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getUseLanguage() {
        return this.useLanguage;
    }

    public String getDomainHash() {
        Integer h = this.domain.hashCode();
        return "" + (h < 0 ? -h.intValue() : h);
    }

    public String getUrchinId() {
        return this.urchinId;
    }

    public void setUrchinId(String urchinId) {
        this.urchinId = urchinId;
    }

    public String getVisitorId() {
        return this.visitorId;
    }

    public String getVisitorNo() {
        Integer h = this.visitorId.hashCode();
        return "" + (h < 0 ? -h.intValue() : h);
    }

    public void setVisitorId(String visitorId) {
        this.visitorId = visitorId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Charset getRequestCharset() {
        return this.requestCharset;
    }
}

