/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.util.HashSet;
import java.util.Set;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.holder.SingletonHolder;
import org.mobylet.core.holder.impl.MobyletSingletonHolder;

public class SingletonUtils {
    private static SingletonHolder singletonHolder;

    public static void initialize(Class<? extends SingletonHolder> holderClass) {
        if (singletonHolder == null && holderClass == null) {
            singletonHolder = new MobyletSingletonHolder();
        } else if (singletonHolder == null && holderClass != null) {
            try {
                singletonHolder = holderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MobyletRuntimeException("SingletonHolder[" + holderClass.getName() + "]\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
            catch (IllegalAccessException e) {
                throw new MobyletRuntimeException("SingletonHolder[" + holderClass.getName() + "]\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        } else {
            throw new MobyletRuntimeException("SingletonHolder\u306f\u65e2\u306b\u69cb\u7bc9\u6e08\u307f\u3067\u3059", null);
        }
    }

    public static boolean isInitialized() {
        return singletonHolder != null;
    }

    public static <S> S get(Class<S> clazz) {
        return singletonHolder.get(clazz);
    }

    public static void put(Object obj) {
        if (obj == null) {
            return;
        }
        Set<Class<?>> interfaces = SingletonUtils.getInterfaces(obj.getClass());
        if (interfaces != null && interfaces.size() > 0) {
            for (Class<?> clazz : interfaces) {
                singletonHolder.set(clazz, obj);
            }
        }
        singletonHolder.set(obj.getClass(), obj);
    }

    private static Set<Class<?>> getInterfaces(Class<?> clazz) {
        HashSet classSet = new HashSet();
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            for (Class<?> i : interfaces) {
                classSet.add(i);
            }
        }
        Class<?> superClass = null;
        superClass = clazz.getSuperclass();
        if (superClass != null) {
            Set<Class<?>> tmpSet = SingletonUtils.getInterfaces(superClass);
            classSet.addAll(tmpSet);
            if (!Object.class.equals(superClass)) {
                classSet.add(superClass);
            }
        }
        return classSet;
    }
}

