/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.xml;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.FieldUtils;
import org.mobylet.core.util.ResourceUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.xml.XmlHandler;
import org.mobylet.core.xml.XmlNode;
import org.xml.sax.helpers.DefaultHandler;

public class Xml {
    protected XmlHandler handler;
    protected XmlNode root;
    protected ClassLoader classLoader;
    private InputStream xmlStream;

    public Xml(String filepath) {
        this(ResourceUtils.getResourceFileOrInputStream(filepath));
    }

    public Xml(InputStream inputStream) {
        this.xmlStream = inputStream;
        this.handler = new XmlHandler();
        this.load();
    }

    public XmlNode getRootNode() {
        return this.root;
    }

    public <T> List<T> copyToBean(String xpath, Class<T> clazz) {
        return this.copyToBean(xpath, clazz, null);
    }

    public <T> List<T> copyToBean(String xpath, Class<T> clazz, String attName) {
        ArrayList<T> beanList = new ArrayList<T>();
        try {
            List<XmlNode> nodeList = this.getRootNode().getNodeListByXPath(xpath);
            Field[] fields = clazz.getDeclaredFields();
            for (XmlNode node : nodeList) {
                List<XmlNode> children = node.getChildren();
                T bean = clazz.newInstance();
                for (Field field : fields) {
                    field.setAccessible(true);
                    List<XmlNode> selectedChildren = node.getChildren(field.getName());
                    if (selectedChildren != null && selectedChildren.size() > 0) {
                        FieldUtils.set(field, bean, selectedChildren.get(0).getValue());
                        continue;
                    }
                    if (node.getAttributes().containsKey(field.getName())) {
                        FieldUtils.set(field, bean, node.getAttributes().get(field.getName()));
                        continue;
                    }
                    if (!StringUtils.isNotEmpty(attName)) continue;
                    for (XmlNode child : children) {
                        if (!StringUtils.equals(child.getAttributes().get(attName), field.getName())) continue;
                        FieldUtils.set(field, bean, child.getValue());
                    }
                }
                beanList.add(bean);
            }
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("XML\u30ce\u30fc\u30c9\u60c5\u5831\u69cb\u7bc9\u4e2d\u306b\u4f8b\u5916\u767a\u751f", e);
        }
        return beanList;
    }

    public <T> Map<String, T> copyToBeanMap(String xpath, Class<T> clazz, String keyField) {
        return this.copyToBeanMap(xpath, clazz, null, keyField);
    }

    public <T> Map<String, T> copyToBeanMap(String xpath, Class<T> clazz, String attName, String keyField) {
        List<T> beanList = this.copyToBean(xpath, clazz, attName);
        return Xml.beanListToMap(beanList, clazz, keyField);
    }

    static <T> Map<String, T> beanListToMap(List<T> beanList, Class<T> clazz, String keyField) {
        try {
            LinkedHashMap<String, T> beanMap = new LinkedHashMap<String, T>();
            Field field = clazz.getDeclaredField(keyField);
            field.setAccessible(true);
            for (T bean : beanList) {
                beanMap.put(FieldUtils.getString(field, bean), bean);
            }
            return beanMap;
        }
        catch (Exception e) {
            throw new MobyletRuntimeException("XML\u60c5\u5831\u3092Map\u3078\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        Xml xml = this;
        synchronized (xml) {
            try {
                SAXParserFactory spfactory = SAXParserFactory.newInstance();
                SAXParser parser = spfactory.newSAXParser();
                this.handler.initialize();
                if (this.xmlStream != null) {
                    parser.parse(this.xmlStream, (DefaultHandler)this.handler);
                    this.root = this.handler.getRootNode();
                }
            }
            catch (Exception e) {
                throw new MobyletRuntimeException("XML\u60c5\u5831\u3092\u30ed\u30fc\u30c9\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
            }
        }
    }
}

