/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;

public class BitInputStream
extends InputStream {
    private static final int DefaultCacheSize = 1024;
    private InputStream in;
    private byte[] cache;
    private int cacheLimit;
    private int cachePosition;
    private int bitBuffer;
    private int bitCount;
    private boolean markPositionIsInCache;
    private byte[] markCache;
    private int markCacheLimit;
    private int markCachePosition;
    private int markBitBuffer;
    private int markBitCount;

    private BitInputStream() {
    }

    public BitInputStream(InputStream inputStream) {
        this(inputStream, 1024);
    }

    public BitInputStream(InputStream inputStream, int n) {
        if (inputStream == null || 4 > n) {
            if (inputStream == null) {
                throw new NullPointerException("in");
            }
            throw new IllegalArgumentException("CacheSize must be 4 or more.");
        }
        this.in = inputStream;
        this.cache = new byte[n];
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.markPositionIsInCache = false;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
    }

    public int read() throws IOException {
        try {
            return this.readBits(8);
        }
        catch (LocalEOFException localEOFException) {
            if (localEOFException.thrownBy(this)) {
                return -1;
            }
            throw localEOFException;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        try {
            while (0 < n2) {
                byArray[n++] = (byte)this.readBits(8);
                --n2;
            }
            return n3;
        }
        catch (LocalEOFException localEOFException) {
            if (localEOFException.thrownBy(this)) {
                if (n3 != n2) {
                    return n3 - n2;
                }
                return -1;
            }
            throw localEOFException;
        }
        catch (BitDataBrokenException bitDataBrokenException) {
            if (bitDataBrokenException.getCause() instanceof LocalEOFException && ((LocalEOFException)bitDataBrokenException.getCause()).thrownBy(this)) {
                this.bitBuffer >>>= bitDataBrokenException.getBitCount();
                this.bitCount += bitDataBrokenException.getBitCount();
                this.bitBuffer |= bitDataBrokenException.getBitData() << 32 - bitDataBrokenException.getBitCount();
                return n3 - n2;
            }
            throw bitDataBrokenException;
        }
    }

    public long skip(long l) throws IOException {
        long l2 = l = 0L < l ? l : 0L;
        try {
            while (0L < l) {
                this.readBits(8);
                --l;
            }
            return l2;
        }
        catch (LocalEOFException localEOFException) {
            return l2 - l;
        }
        catch (BitDataBrokenException bitDataBrokenException) {
            if (bitDataBrokenException.getCause() instanceof LocalEOFException && ((LocalEOFException)bitDataBrokenException.getCause()).thrownBy(this)) {
                this.bitBuffer >>>= bitDataBrokenException.getBitCount();
                this.bitCount += bitDataBrokenException.getBitCount();
                this.bitBuffer |= bitDataBrokenException.getBitData() << 32 - bitDataBrokenException.getBitCount();
                return l2 - l;
            }
            throw bitDataBrokenException;
        }
    }

    public void mark(int n) {
        n -= this.cacheLimit - this.cachePosition;
        n -= this.bitCount / 8;
        n = (n += 4) / this.cache.length * this.cache.length + (n % this.cache.length == 0 ? 0 : this.cache.length);
        this.in.mark(n);
        if (this.markCache == null) {
            this.markCache = (byte[])this.cache.clone();
        } else {
            System.arraycopy(this.cache, 0, this.markCache, 0, this.cacheLimit);
        }
        this.markCacheLimit = this.cacheLimit;
        this.markCachePosition = this.cachePosition;
        this.markBitBuffer = this.bitBuffer;
        this.markBitCount = this.bitCount;
        this.markPositionIsInCache = true;
    }

    public void reset() throws IOException {
        if (this.markPositionIsInCache) {
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
        } else {
            if (!this.in.markSupported()) {
                throw new IOException("not support mark()/reset().");
            }
            if (this.markCache == null) {
                throw new IOException("not marked.");
            }
            this.in.reset();
            System.arraycopy(this.markCache, 0, this.cache, 0, this.markCacheLimit);
            this.cacheLimit = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
            this.bitBuffer = this.markBitBuffer;
            this.bitCount = this.markBitCount;
        }
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return this.availableBits() / 8;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.cache = null;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        this.bitBuffer = 0;
        this.bitCount = 0;
        this.markCache = null;
        this.markCacheLimit = 0;
        this.markCachePosition = 0;
        this.markBitBuffer = 0;
        this.markBitCount = 0;
        this.markPositionIsInCache = false;
    }

    public int readBit() throws IOException {
        if (0 < this.bitCount) {
            int n = this.bitBuffer >>> 31;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return n;
        }
        try {
            this.fillBitBuffer();
            int n = this.bitBuffer >>> 31;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return n;
        }
        catch (LocalEOFException localEOFException) {
            if (localEOFException.thrownBy(this)) {
                return -1;
            }
            throw localEOFException;
        }
    }

    public boolean readBoolean() throws IOException {
        if (0 < this.bitCount) {
            boolean bl = this.bitBuffer < 0;
            this.bitBuffer <<= 1;
            --this.bitCount;
            return bl;
        }
        this.fillBitBuffer();
        boolean bl = this.bitBuffer < 0;
        this.bitBuffer <<= 1;
        --this.bitCount;
        return bl;
    }

    public int readBits(int n) throws IOException {
        if (0 < n) {
            if (n <= this.bitCount) {
                int n2 = this.bitBuffer >>> 32 - n;
                this.bitBuffer <<= n;
                this.bitCount -= n;
                return n2;
            }
            int n3 = n;
            int n4 = 0;
            try {
                this.fillBitBuffer();
                while (this.bitCount < n) {
                    if ((n -= this.bitCount) < 32) {
                        n4 |= this.bitBuffer >>> 32 - this.bitCount << n;
                    }
                    this.bitBuffer = 0;
                    this.bitCount = 0;
                    this.fillBitBuffer();
                }
                this.bitBuffer <<= n;
                this.bitCount -= n;
                return n4 |= this.bitBuffer >>> 32 - n;
            }
            catch (LocalEOFException localEOFException) {
                if (localEOFException.thrownBy(this) && n < n3) {
                    throw new BitDataBrokenException(localEOFException, n4 >>> n, n3 - n);
                }
                throw localEOFException;
            }
        }
        return 0;
    }

    public int skipBits(int n) throws IOException {
        if ((n = Math.max(n, 0)) < this.bitCount) {
            this.bitBuffer <<= n;
            this.bitCount -= n;
            return n;
        }
        int n2 = n;
        n -= this.bitCount;
        this.bitCount = 0;
        this.bitBuffer = 0;
        try {
            while ((this.cacheLimit - this.cachePosition) * 8 <= n) {
                n -= (this.cacheLimit - this.cachePosition) * 8;
                this.cachePosition = this.cacheLimit;
                this.fillCache();
                if (this.cacheLimit != this.cachePosition) continue;
                throw new LocalEOFException(this);
            }
            this.cachePosition += n >> 3;
            if (0 < (n &= 7)) {
                this.bitCount = 8 - n;
                this.bitBuffer = this.cache[this.cachePosition++] << 24 + n;
                n = 0;
            }
        }
        catch (LocalEOFException localEOFException) {
            // empty catch block
        }
        return n2 - n;
    }

    public int peekBit() throws IOException {
        if (0 < this.bitCount) {
            return this.bitBuffer >>> 31;
        }
        try {
            this.fillBitBuffer();
            return this.bitBuffer >>> 31;
        }
        catch (LocalEOFException localEOFException) {
            if (localEOFException.thrownBy(this)) {
                return -1;
            }
            throw localEOFException;
        }
    }

    public boolean peekBoolean() throws IOException {
        if (0 < this.bitCount) {
            return this.bitBuffer < 0;
        }
        this.fillBitBuffer();
        return this.bitBuffer < 0;
    }

    public int peekBits(int n) throws IOException {
        if (0 < n) {
            if (n <= this.bitCount) {
                return this.bitBuffer >>> 32 - n;
            }
            this.fillBitBuffer();
            if (n <= this.bitCount) {
                return this.bitBuffer >>> 32 - n;
            }
            if (n <= this.cachedBits()) {
                if (n <= 32) {
                    int n2 = this.bitBuffer;
                    return (n2 |= (this.cache[this.cachePosition] & 0xFF) >> this.bitCount - 24) >>> 32 - n;
                }
                if (n - 32 < this.bitCount) {
                    int n3;
                    int n4 = this.bitBuffer << n - 32;
                    int n5 = this.cachePosition;
                    for (n3 = this.bitCount - (n - 32); n3 < 25; n3 += 8) {
                        n4 |= (this.cache[n5++] & 0xFF) << 24 - n3;
                    }
                    if (n3 < 32) {
                        n4 |= (this.cache[n5] & 0xFF) >> n3 - 24;
                    }
                    return n4;
                }
                n -= this.bitCount;
                int n6 = this.cachePosition + ((n -= 32) >> 3);
                if (0 < (n &= 7)) {
                    return this.cache[n6] << 24 + n | (this.cache[n6 + 1] & 0xFF) << 16 + n | (this.cache[n6 + 2] & 0xFF) << 8 + n | (this.cache[n6 + 3] & 0xFF) << n | (this.cache[n6 + 4] & 0xFF) >> 8 - n;
                }
                return this.cache[n6] << 24 | (this.cache[n6 + 1] & 0xFF) << 16 | (this.cache[n6 + 2] & 0xFF) << 8 | this.cache[n6 + 3] & 0xFF;
            }
            throw new NotEnoughBitsException(this.cachedBits());
        }
        return 0;
    }

    public int availableBits() throws IOException {
        int n = this.cacheLimit - this.cachePosition + this.in.available() / this.cache.length * this.cache.length;
        return Math.max(n += this.bitCount - 32, 0);
    }

    private int cachedBits() {
        return this.bitCount + (this.cacheLimit - this.cachePosition << 3);
    }

    private void fillBitBuffer() throws IOException {
        if (32 <= this.cachedBits()) {
            if (this.bitCount <= 24) {
                if (this.bitCount <= 16) {
                    if (this.bitCount <= 8) {
                        if (this.bitCount <= 0) {
                            this.bitBuffer = this.cache[this.cachePosition++] << 24;
                            this.bitCount = 8;
                        }
                        this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                        this.bitCount += 8;
                    }
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
        } else if (this.bitCount < 25) {
            if (this.bitCount == 0) {
                this.bitBuffer = 0;
            }
            int n = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
            while (0 < n--) {
                this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                this.bitCount += 8;
            }
            this.fillCache();
            if (this.cachePosition < this.cacheLimit) {
                n = Math.min(32 - this.bitCount >> 3, this.cacheLimit - this.cachePosition);
                while (0 < n--) {
                    this.bitBuffer |= (this.cache[this.cachePosition++] & 0xFF) << 24 - this.bitCount;
                    this.bitCount += 8;
                }
            } else if (this.bitCount <= 0) {
                throw new LocalEOFException(this);
            }
        }
    }

    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit = 0;
        this.cachePosition = 0;
        int n = 0;
        while (0 <= n && this.cacheLimit < this.cache.length) {
            n = this.in.read(this.cache, this.cacheLimit, this.cache.length - this.cacheLimit);
            if (0 >= n) continue;
            this.cacheLimit += n;
        }
    }

    private static class LocalEOFException
    extends EOFException {
        private Object owner;

        public LocalEOFException(Object object) {
            this.owner = object;
        }

        public boolean thrownBy(Object object) {
            return this.owner == object;
        }
    }
}

