/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class CompositionShiftLeastGreatestAtom
extends AbstractFullBox {
    int compositionOffsetToDisplayOffsetShift;
    int leastDisplayOffset;
    int greatestDisplayOffset;
    int displayStartTime;
    int displayEndTime;

    public CompositionShiftLeastGreatestAtom() {
        super(IsoFile.fourCCtoBytes("cslg"));
    }

    protected long getContentSize() {
        return 20L;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeInt32(this.compositionOffsetToDisplayOffsetShift);
        os.writeInt32(this.leastDisplayOffset);
        os.writeInt32(this.greatestDisplayOffset);
        os.writeInt32(this.displayStartTime);
        os.writeInt32(this.displayEndTime);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.compositionOffsetToDisplayOffsetShift = in.readInt32();
        this.leastDisplayOffset = in.readInt32();
        this.greatestDisplayOffset = in.readInt32();
        this.displayStartTime = in.readInt32();
        this.displayEndTime = in.readInt32();
    }

    public int getCompositionOffsetToDisplayOffsetShift() {
        return this.compositionOffsetToDisplayOffsetShift;
    }

    public void setCompositionOffsetToDisplayOffsetShift(int compositionOffsetToDisplayOffsetShift) {
        this.compositionOffsetToDisplayOffsetShift = compositionOffsetToDisplayOffsetShift;
    }

    public int getLeastDisplayOffset() {
        return this.leastDisplayOffset;
    }

    public void setLeastDisplayOffset(int leastDisplayOffset) {
        this.leastDisplayOffset = leastDisplayOffset;
    }

    public int getGreatestDisplayOffset() {
        return this.greatestDisplayOffset;
    }

    public void setGreatestDisplayOffset(int greatestDisplayOffset) {
        this.greatestDisplayOffset = greatestDisplayOffset;
    }

    public int getDisplayStartTime() {
        return this.displayStartTime;
    }

    public void setDisplayStartTime(int displayStartTime) {
        this.displayStartTime = displayStartTime;
    }

    public int getDisplayEndTime() {
        return this.displayEndTime;
    }

    public void setDisplayEndTime(int displayEndTime) {
        this.displayEndTime = displayEndTime;
    }
}

