/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.TrackBoxContainer;
import com.coremedia.iso.boxes.TrackMetaData;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieFragmentBox
extends AbstractContainerBox
implements TrackBoxContainer<TrackFragmentBox> {
    public static final String TYPE = "moof";

    public MovieFragmentBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public List<Long> getSyncSamples(SampleDependencyTypeBox sdtp) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<SampleDependencyTypeBox.Entry> sampleEntries = sdtp.getEntries();
        long i = 1L;
        for (SampleDependencyTypeBox.Entry sampleEntry : sampleEntries) {
            if (sampleEntry.getSampleDependsOn() == 2) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getTrackCount() {
        return this.getBoxes(TrackFragmentBox.class, false).size();
    }

    @Override
    public long[] getTrackNumbers() {
        List<TrackFragmentBox> trackBoxes = this.getBoxes(TrackFragmentBox.class, false);
        long[] trackNumbers = new long[trackBoxes.size()];
        for (int trackCounter = 0; trackCounter < trackBoxes.size(); ++trackCounter) {
            TrackFragmentBox trackBoxe = trackBoxes.get(trackCounter);
            trackNumbers[trackCounter] = trackBoxe.getTrackFragmentHeaderBox().getTrackId();
        }
        return trackNumbers;
    }

    @Override
    public TrackMetaData<TrackFragmentBox> getTrackMetaData(long trackId) {
        List<TrackFragmentBox> trackBoxes = this.getBoxes(TrackFragmentBox.class, false);
        for (TrackFragmentBox trackFragmentBox : trackBoxes) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
            return new TrackMetaData<TrackFragmentBox>(trackId, trackFragmentBox);
        }
        throw new RuntimeException("TrackId " + trackId + " not contained in " + this);
    }
}

