/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.util.concurrent.ExecutorService;
import org.carrot2.core.ExecutorServiceShutdownListener;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.ProcessingException;
import org.carrot2.util.ExecutorServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessingComponentBase
implements IProcessingComponent {
    private IControllerContext context;

    @Override
    public void init(IControllerContext context) {
        this.context = context;
    }

    @Override
    public void beforeProcessing() throws ProcessingException {
    }

    @Override
    public void process() throws ProcessingException {
    }

    @Override
    public void afterProcessing() {
    }

    protected final IControllerContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("Context not available (check if you call super.init(ControllerContext)).");
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getSharedExecutor(int maxConcurrentThreads, Class<?> clazz) {
        IControllerContext context;
        IControllerContext iControllerContext = context = this.getContext();
        synchronized (iControllerContext) {
            String contextKey = clazz.getName() + ".executorService";
            ExecutorService service = (ExecutorService)context.getAttribute(contextKey);
            if (service == null) {
                service = ExecutorServiceUtils.createExecutorService(maxConcurrentThreads, clazz);
                context.setAttribute(contextKey, service);
                context.addListener(new ExecutorServiceShutdownListener(contextKey));
            }
            return service;
        }
    }

    @Override
    public void dispose() {
    }
}

