/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix;

import org.apache.commons.lang.StringUtils;
import org.carrot2.matrix.nni.BlasImpl;
import org.carrot2.matrix.nni.IBlasOperations;
import org.carrot2.matrix.nni.ILapackOperations;
import org.carrot2.matrix.nni.LapackImpl;
import org.carrot2.util.annotations.AspectModified;
import org.slf4j.LoggerFactory;

public class NNIInterface {
    private static final IBlasOperations blas;
    private static final ILapackOperations lapack;
    private static volatile boolean suppressNNI;

    private NNIInterface() {
    }

    public static boolean isNativeBlasAvailable() {
        return suppressNNI ? false : blas != null;
    }

    public static boolean isNativeLapackAvailable() {
        return suppressNNI ? false : lapack != null;
    }

    public static void suppressNNI(boolean suppress) {
        suppressNNI = suppress;
    }

    public static IBlasOperations getBlas() {
        if (blas == null) {
            throw new RuntimeException("No native blas available.");
        }
        return blas;
    }

    public static ILapackOperations getLapack() {
        if (lapack == null) {
            throw new RuntimeException("No native blas available.");
        }
        return lapack;
    }

    @AspectModified
    private static final ILapackOperations instantiateLapack() {
        try {
            return new LapackImpl();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(NNIInterface.class).info("Native LAPACK not available: " + StringUtils.defaultIfEmpty((String)t.getMessage(), (String)"(no message). Java matrix routines will be used."));
            return null;
        }
    }

    @AspectModified
    private static final IBlasOperations instantiateBlas() {
        try {
            return new BlasImpl();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(NNIInterface.class).info("Native BLAS not available: " + StringUtils.defaultIfEmpty((String)t.getMessage(), (String)"(no message). Java matrix routines will be used."));
            return null;
        }
    }

    static {
        lapack = NNIInterface.instantiateLapack();
        blas = NNIInterface.instantiateBlas();
    }
}

