/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.MatrixUtils;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class NonnegativeMatrixFactorizationKL
extends IterativeMatrixFactorizationBase {
    public NonnegativeMatrixFactorizationKL(DoubleMatrix2D A) {
        super(A);
    }

    public void compute() {
        int m = this.A.rows();
        int n = this.A.columns();
        double eps = 1.0E-9;
        this.U = this.doubleFactory2D.make(m, this.k);
        this.V = this.doubleFactory2D.make(n, this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D Aeps = this.A.copy().assign(Functions.plus((double)eps));
        DoubleMatrix2D UV = this.doubleFactory2D.make(m, n);
        DoubleMatrix2D VT = this.doubleFactory2D.make(n, this.k);
        DoubleMatrix2D UT = this.doubleFactory2D.make(m, this.k);
        double[] work = new double[this.U.columns()];
        BinaryFunction invDiv = Functions.swapArgs((BinaryFunction)Functions.div);
        UnaryFunction plusEps = Functions.plus((double)eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.V, UV, 1.0, 0.0, false, true);
            UV.assign(plusEps);
            UV.assign(Aeps, invDiv);
            UV.zMult(this.U, VT, 1.0, 0.0, true, false);
            this.V.assign(VT, Functions.mult);
            this.U.zMult(this.V, UV, 1.0, 0.0, false, true);
            UV.assign(plusEps);
            UV.assign(Aeps, invDiv);
            UV.zMult(this.V, UT, 1.0, 0.0, false, false);
            this.U.assign(UT, Functions.mult);
            MatrixUtils.normalizeColumnL1(this.U, work);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "NMF-KL-" + this.seedingStrategy.toString();
    }
}

