/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.google;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBase;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.resource.ClassResource;
import org.carrot2.util.resource.IResource;

@Bindable(prefix="GoogleDesktopDocumentSource")
public class GoogleDesktopDocumentSource
extends RemoteXmlSimpleSearchEngineBase {
    @Input
    @Processing
    @Attribute
    public String queryUrl = GoogleDesktopDocumentSource.getQueryUrlFromRegistry();
    @Input
    @Processing
    @Attribute
    public boolean keepHighlights = false;

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        if (StringUtils.isBlank((String)this.queryUrl)) {
            SearchEngineResponse response = new SearchEngineResponse();
            String windowsHint = "2) Try running the application as an Administrator, 3) If you can't run the application as an Administrator, set the Query URL attribute manually.";
            String otherHint = "2) In the Search view, set the Query URL (optional) attribute to point to the Query URL of your Google Desktop installation. See the attribute's inline help for more information.";
            response.results.add(new Document("Could not connect to Google Desktop", "To fix the problem: 1) Make sure Google Desktop is installed on your machine, " + (SystemUtils.IS_OS_WINDOWS ? "2) Try running the application as an Administrator, 3) If you can't run the application as an Administrator, set the Query URL attribute manually." : "2) In the Search view, set the Query URL (optional) attribute to point to the Query URL of your Google Desktop installation. See the attribute's inline help for more information."), ""));
            return response;
        }
        return super.fetchSearchResponse();
    }

    protected String buildServiceUrl() {
        return this.queryUrl + org.carrot2.util.StringUtils.urlEncodeWrapException(this.query, "UTF-8") + "&format=xml&num=" + this.results;
    }

    protected IResource getXsltResource() {
        return new ClassResource(GoogleDesktopDocumentSource.class, "google-desktop-to-c2.xsl");
    }

    protected void afterFetch(SearchEngineResponse response) {
        GoogleDesktopDocumentSource.clean(response, this.keepHighlights, "title", "snippet");
    }

    static String getQueryUrlFromRegistry() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return null;
        }
        String command = "reg query \"HKCU\\Software\\Google\\Google Desktop\\API\" /v search_url";
        String stringSymbol = "REG_SZ";
        try {
            Process process = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\Google\\Google Desktop\\API\" /v search_url");
            final InputStream is = process.getInputStream();
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new Thread(){

                public void run() {
                    try {
                        StreamUtils.copyAndClose(is, baos, 4096);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            process.waitFor();
            String result = new String(baos.toByteArray(), "UTF-8");
            int p = result.indexOf("REG_SZ");
            if (p == -1) {
                return null;
            }
            return result.substring(p + "REG_SZ".length()).trim();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }
}

