/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.yahoo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.yahoo.XMLResponseParser;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.httpclient.HttpHeaders;
import org.carrot2.util.httpclient.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bindable(prefix="YahooSearchService")
public abstract class YahooSearchService {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String FIRST_INDEX_KEY = "firstIndex";
    public static final String RESULTS_RETURNED_KEY = "resultsReturned";
    @Init
    @Input
    @Attribute
    public String appid = "carrotsearch";
    @Processing
    @Input
    @Attribute
    public QueryType type = QueryType.ALL;
    @Processing
    @Input
    @Attribute
    public String language;
    protected MultipageSearchEngineMetadata metadata = DEFAULT_METADATA;
    static final MultipageSearchEngineMetadata DEFAULT_METADATA = new MultipageSearchEngineMetadata(50, 1000);

    YahooSearchService() {
    }

    protected abstract ArrayList<NameValuePair> createRequestParams(String var1, int var2, int var3);

    protected abstract String getServiceURI();

    protected final SearchEngineResponse query(String query, int start, int results) throws IOException {
        results = Math.min(results, this.metadata.resultsPerPage);
        ArrayList<NameValuePair> params = this.createRequestParams(query, ++start, results);
        params.add((NameValuePair)new BasicNameValuePair("output", "xml"));
        HttpUtils.Response response = HttpUtils.doGET(this.getServiceURI(), params, Arrays.asList(HttpHeaders.USER_AGENT_HEADER_MOZILLA));
        int statusCode = response.status;
        if (statusCode == 200 || statusCode == 503 || statusCode == 400) {
            SearchEngineResponse ser = YahooSearchService.parseResponseXML(response.getPayloadAsStream());
            ser.metadata.put("compression", response.compression);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Received, results: " + ser.results.size() + ", total: " + ser.getResultsTotal() + ", first: " + ser.metadata.get(FIRST_INDEX_KEY));
            }
            return ser;
        }
        String m = "Yahoo returned HTTP Error: " + statusCode + ", HTTP payload: " + new String(response.payload, "iso8859-1");
        this.logger.warn(m);
        throw new IOException(m);
    }

    private static SearchEngineResponse parseResponseXML(InputStream is) throws IOException {
        try {
            XMLResponseParser parser = new XMLResponseParser();
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setContentHandler(parser);
            reader.parse(new InputSource(is));
            return parser.response;
        }
        catch (SAXException e) {
            Exception cause = e.getException();
            if (cause != null && cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("XML parsing exception: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Could not acquire XML parser.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryType {
        ALL("search for all words"),
        ANY("search for any word"),
        PHRASE("search for phrase");

        private String label;

        private QueryType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public String getApiOption() {
            return this.name().toLowerCase();
        }
    }
}

