/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;

@Bindable(prefix="QueryLabelFilter")
public class QueryLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    public boolean enabled = true;

    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        short[] flag = context.allWords.type;
        for (int i = 0; i < wordIndices.length; ++i) {
            if (this.isQueryWord(flag[wordIndices[i]])) continue;
            return true;
        }
        return false;
    }

    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return !this.isQueryWord(context.allWords.type[wordIndex]);
    }

    private final boolean isQueryWord(short flag) {
        return (flag & 0x2000) != 0;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

