/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.carrot2.util.attribute.constraint.IValueHintMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueHintMappingUtils {
    private ValueHintMappingUtils() {
    }

    public static Map<String, Enum<?>> getValidValuesMap(Class<? extends Enum<?>> clazz) {
        LinkedHashMap valueSet = Maps.newLinkedHashMap();
        for (Enum<?> e : clazz.getEnumConstants()) {
            String value = e.name();
            if (e instanceof IValueHintMapping) {
                value = ((IValueHintMapping)((Object)e)).getAttributeValue();
            }
            valueSet.put(value, e);
        }
        return valueSet;
    }

    public static BiMap<String, String> getValueToFriendlyName(Class<? extends Enum<?>> clazz) {
        HashBiMap valueToName = HashBiMap.create();
        for (Enum<?> e : clazz.getEnumConstants()) {
            String value = e.name();
            String name = e.toString();
            if (e instanceof IValueHintMapping) {
                value = ((IValueHintMapping)((Object)e)).getAttributeValue();
                name = ((IValueHintMapping)((Object)e)).getUserFriendlyName();
            }
            valueToName.put((Object)value, (Object)name);
        }
        return valueToName;
    }
}

