/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.xsltfilter;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import org.carrot2.util.xslt.TemplatesPool;
import org.carrot2.util.xslt.TransformerErrorListener;
import org.carrot2.util.xsltfilter.IContentTypeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransformingDocumentHandler
implements ContentHandler {
    private static final Logger log = LoggerFactory.getLogger(TransformingDocumentHandler.class);
    private static final HashMap<String, String> methodMapping = new HashMap();
    private final Pattern typePattern = Pattern.compile("(type[ \t]*=[ \\t]*\")([^\"]*)(\")", 2);
    private final Pattern hrefPattern = Pattern.compile("(href[ \\t]*=[ \\t]*\")([^\"]*)(\")", 2);
    private final Pattern resourcePattern = Pattern.compile("(resource[ \\t]*=[ \\t]*\")([^\"]*)(\")", 2);
    private HttpServletRequest request;
    private TransformerHandler defaultHandler;
    private TransformerHandler contentHandler;
    private ServletContext context;
    private Result result;
    private TransformerErrorListener transformerErrorListener = new TransformerErrorListener();
    private Locator locator;
    private TemplatesPool pool;
    private IContentTypeListener contentTypeListener;
    private final Map<String, Object> stylesheetParams;

    public TransformingDocumentHandler(HttpServletRequest request, ServletContext context, Map<String, Object> stylesheetParams, TemplatesPool pool) {
        this.request = request;
        this.context = context;
        this.pool = pool;
        this.stylesheetParams = stylesheetParams;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.initContentHandler();
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        block3: {
            this.initContentHandler();
            try {
                this.contentHandler.endDocument();
            }
            catch (RuntimeException t) {
                TransformerException transformerException = this.transformerErrorListener.exception;
                if (transformerException == null) break block3;
                Throwable cause = transformerException.getCause();
                if (cause != null && cause instanceof Exception) {
                    throw new SAXException("XSLT transformation error.", (Exception)cause);
                }
                throw new SAXException("XSLT transformation error.", transformerException);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.initContentHandler();
        this.contentHandler.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.initContentHandler();
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.initContentHandler();
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler == null) {
            this.inspectProcessingInstruction(this, target, data);
        }
        this.initContentHandler();
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.initContentHandler();
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.initContentHandler();
        this.contentHandler.startElement(namespaceURI, localName, qName, atts);
    }

    private void setTransformerHandler(TransformerHandler fallbackHandler) throws SAXException {
        if (this.contentHandler != null) {
            throw new SAXException("Some input has been already processed. Cannot change the handler anymore. Place xml-stylesheet directive immediately at the top of the XML file.");
        }
        Transformer transformer = fallbackHandler.getTransformer();
        if (this.stylesheetParams != null) {
            for (Map.Entry<String, Object> entry : this.stylesheetParams.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        this.defaultHandler = fallbackHandler;
    }

    public final void setContentTypeListener(IContentTypeListener l) {
        this.contentTypeListener = l;
    }

    public final void cleanup() {
        if (this.defaultHandler != null) {
            this.defaultHandler.getTransformer().reset();
        }
    }

    public void setTransformationResult(Result result) {
        this.result = result;
    }

    private URI processXmlStylesheet(String target, String data) {
        if (!target.equals("xml-stylesheet")) {
            return null;
        }
        Matcher typeMatcher = this.typePattern.matcher(data);
        if (!typeMatcher.find()) {
            log.warn("xml-stylesheet directive with no type attribute (should be text/xsl).");
            return null;
        }
        String type = typeMatcher.group(2);
        if (!"text/xsl".equals(type)) {
            log.warn("xml-stylesheet directive with incorrect type (should be text/xsl): " + type);
            return null;
        }
        Matcher hrefMatcher = this.hrefPattern.matcher(data);
        if (!hrefMatcher.find()) {
            log.warn("xml-stylesheet directive with no 'href' pseudo-attribute.");
            return null;
        }
        URI base = URI.create(this.request.getRequestURI());
        String stylesheetURI = hrefMatcher.group(2);
        return base.resolve(stylesheetURI);
    }

    private URI processExtStylesheet(String target, String data) {
        if (!target.equals("ext-stylesheet")) {
            return null;
        }
        Matcher resourceMatcher = this.resourcePattern.matcher(data);
        if (!resourceMatcher.find()) {
            log.warn("ext-stylesheet directive with no 'resource' attribute.");
            return null;
        }
        String stylesheetURI = resourceMatcher.group(2);
        try {
            URL stylesheetURL = this.context.getResource(stylesheetURI);
            return stylesheetURL == null ? null : stylesheetURL.toURI();
        }
        catch (MalformedURLException e) {
            log.error("Malformed stylesheet URL: " + stylesheetURI, (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error("Stylesheet URI conversion error: " + stylesheetURI, (Throwable)e);
        }
        return null;
    }

    public void inspectProcessingInstruction(TransformingDocumentHandler handler, String target, String data) throws SAXException {
        URI uri = this.processExtStylesheet(target, data);
        if (uri != null) {
            log.debug("Resolved ext-stylesheet URI: " + uri.toString());
        } else {
            uri = this.processXmlStylesheet(target, data);
            if (uri != null) {
                log.debug("Resolved xml-stylesheet URI: " + uri.toString());
            } else {
                return;
            }
        }
        String uriString = uri.toString();
        try {
            Templates template = this.pool.getTemplate(uriString);
            if (template == null) {
                template = this.pool.compileTemplate(uriString);
                this.pool.addTemplate(uriString, template);
            }
            if (this.contentTypeListener != null) {
                Properties outputProps = template.getOutputProperties();
                String contentType = null;
                if (TransformingDocumentHandler.hasKey(outputProps, "media-type")) {
                    contentType = outputProps.getProperty("media-type");
                } else if (TransformingDocumentHandler.hasKey(outputProps, "method")) {
                    String method = outputProps.getProperty("method");
                    contentType = methodMapping.get(method);
                }
                if (contentType == null) {
                    contentType = methodMapping.get("xml");
                }
                String encoding = TransformingDocumentHandler.hasKey(outputProps, "encoding") ? outputProps.getProperty("encoding") : "UTF-8";
                this.contentTypeListener.setContentType(contentType, encoding);
            }
            TransformerHandler tHandler = this.pool.newTransformerHandler(template);
            tHandler.getTransformer().setErrorListener(this.transformerErrorListener);
            handler.setTransformerHandler(tHandler);
        }
        catch (TransformerConfigurationException e) {
            log.error("Transformer configuration exception.", (Throwable)e);
        }
    }

    private static boolean hasKey(Properties props, String key) {
        return props.getProperty(key) != null;
    }

    private final void initContentHandler() throws SAXException {
        if (this.contentHandler == null) {
            if (this.defaultHandler == null) {
                log.info("Stylesheet not specified, using identity handler.");
                try {
                    this.defaultHandler = this.pool.getIdentityTransformerHandler();
                }
                catch (TransformerConfigurationException e) {
                    throw new RuntimeException("Could not create identity handler.");
                }
                if (this.contentTypeListener != null) {
                    this.contentTypeListener.setContentType(methodMapping.get("xml"), null);
                }
            }
            log.debug("XSLT transformation using handler: " + this.defaultHandler.getClass().getName());
            this.contentHandler = this.defaultHandler;
            this.contentHandler.setResult(this.result);
            this.contentHandler.startDocument();
            if (this.locator != null) {
                this.contentHandler.setDocumentLocator(this.locator);
            }
        }
        if (this.transformerErrorListener.exception != null) {
            throw new SAXException("XSLT transformation error.", this.transformerErrorListener.exception);
        }
    }

    static {
        methodMapping.put("xml", "application/xml");
        methodMapping.put("html", "text/html");
        methodMapping.put("text", "text/plain");
    }
}

