/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableFloatFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.NumberUtils;

public class SortableFloatField
extends PrimitiveFieldType {
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new SortableFloatFieldSource(field.name);
    }

    public String toInternal(String val) {
        return NumberUtils.float2sortableStr(val);
    }

    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    public Float toObject(Fieldable f) {
        return Float.valueOf(NumberUtils.SortableStr2float(f.stringValue()));
    }

    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2floatStr(indexedForm);
    }

    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        xmlWriter.writeFloat(name, NumberUtils.SortableStr2float(sval));
    }

    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        writer.writeFloat(name, NumberUtils.SortableStr2float(sval));
    }
}

