/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.helper;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;

public class ContentLengthHelper {
    @Binding(bindingType=BindingType.MAY)
    protected long defaultMaxLength = 0xA00000L;
    protected Map<String, Long> maxLengthMap = new HashMap<String, Long>();

    public void addMaxLength(String mimeType, long maxLength) {
        if (StringUtil.isBlank((String)mimeType)) {
            throw new RobotSystemException("MIME type is a blank.");
        }
        if (maxLength < 0L) {
            throw new RobotSystemException("The value of maxLength is invalid.");
        }
        this.maxLengthMap.put(mimeType, maxLength);
    }

    public long getMaxLength(String mimeType) {
        if (StringUtil.isBlank((String)mimeType)) {
            return this.defaultMaxLength;
        }
        Long maxLength = this.maxLengthMap.get(mimeType);
        if (maxLength != null && maxLength >= 0L) {
            return maxLength;
        }
        return this.defaultMaxLength;
    }

    public long getDefaultMaxLength() {
        return this.defaultMaxLength;
    }

    public void setDefaultMaxLength(long defaultMaxLength) {
        this.defaultMaxLength = defaultMaxLength;
    }
}

