/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.transformer.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.AccessResultData;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.ResultData;
import org.seasar.robot.transformer.impl.AbstractTransformer;

public class BinaryTransformer
extends AbstractTransformer {
    public ResultData transform(ResponseData responseData) {
        ResultData resultData;
        if (responseData == null || responseData.getResponseBody() == null) {
            throw new RobotCrawlAccessException("No response body.");
        }
        ResultData resultData2 = new ResultData();
        resultData2.setTransformerName(this.getName());
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(responseData.getResponseBody());
            resultData2.setData(IOUtils.toByteArray((InputStream)bis));
            resultData2.setEncoding(responseData.getCharSet());
            resultData = resultData2;
            Object var6_6 = null;
        }
        catch (IOException e) {
            try {
                throw new RobotSystemException("Could not convert the input stream.", e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                IOUtils.closeQuietly((InputStream)bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        return resultData;
    }

    public Object getData(AccessResultData accessResultData) {
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new RobotSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }
}

