/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.util.List;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.filters.ColumnNameExpression;
import jp.sf.orangesignal.csv.filters.CsvExpressionUtils;

public class ColumnNameRegexExpression
extends ColumnNameExpression {
    private Pattern pattern;

    protected ColumnNameRegexExpression(String name, String pattern) {
        this(name, pattern, 0);
    }

    protected ColumnNameRegexExpression(String name, String pattern, boolean ignoreCase) {
        this(name, pattern, ignoreCase ? 2 : 0);
    }

    protected ColumnNameRegexExpression(String name, String pattern, int flags) {
        super(name);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    protected ColumnNameRegexExpression(String name, Pattern pattern) {
        super(name);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = pattern;
    }

    @Override
    public boolean accept(List<String> header, List<String> values) {
        int position = header.indexOf(this.name);
        if (position == -1) {
            throw new IllegalArgumentException(String.format("Invalid column name %s", this.name));
        }
        return CsvExpressionUtils.regex(values, position, this.pattern);
    }
}

