/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatByteProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractFloatByteMap
extends AbstractSet {
    public boolean containsKey(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final byte value) {
        return !this.forEachPair(new FloatByteProcedure(){

            public boolean apply(float iterKey, byte iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractFloatByteMap copy() {
        return (AbstractFloatByteMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatByteMap)) {
            return false;
        }
        final AbstractFloatByteMap other = (AbstractFloatByteMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatByteProcedure(){

            public boolean apply(float key, byte value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new FloatByteProcedure(){

            public boolean apply(float key, byte value) {
                return AbstractFloatByteMap.this.containsKey(key) && AbstractFloatByteMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatByteProcedure procedure) {
        return this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                return procedure.apply(key, AbstractFloatByteMap.this.get(key));
            }
        });
    }

    public abstract byte get(float var1);

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList keyList) {
        this.pairsSortedByValue(keyList, new ByteArrayList(this.size()));
    }

    public void pairsMatching(final FloatByteProcedure condition, final FloatArrayList keyList, final ByteArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new FloatByteProcedure(){

            public boolean apply(float key, byte value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(FloatArrayList keyList, ByteArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final float[] k = keyList.elements();
        final byte[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                byte t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                float t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(float var1, byte var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        FloatArrayList theKeys = new FloatArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ByteArrayList values() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            public boolean apply(float key) {
                list.add(AbstractFloatByteMap.this.get(key));
                return true;
            }
        });
    }

    public byte adjustOrPutValue(float key, byte newValue, byte incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (byte)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

